import Sct.IS.*;
import Sct.*;
import SctData.*;
import hep.aida.*;
import hep.aida.ref.histogram.*;

public class CheckRaw {
    public int runNumber;
    public int scanNumber;
    public String moduleName;
    public byte groupID;
    public float chip5CalFactor;
    public byte chip4Target;
    public byte chip11Threshold;
    public byte chip0Chan0Trim;
    public int nPoints;
    public double point0;
    public double bin00;
    public double bin4930;
    public int exitCode = 0;
    RawScanResult r;
    
    public void compare(String name) throws java.io.IOException{
	Serializable s = ObjectManagerIS.getInstance().readObject(name);
	System.out.println(name + "  " + s.getClassName());
	r = (RawScanResult)s;
	
	if (r.getHeader().getRunNumber() != runNumber) {
	    System.err.println("RunNumber not equal. Got: " + r.getHeader().getRunNumber() + " expected: " + runNumber);
	    ++exitCode;
	}
	
	if (r.getHeader().getScanNumber() != scanNumber) {
	    System.err.println("ScanNumber not equal. Got: " + r.getHeader().getScanNumber() + " expected: " + scanNumber);
	    ++exitCode;
	}

	if (!r.getHeader().getModuleName().equals(moduleName)) {
	    System.err.println("ModuleName not equal. Got: " + r.getHeader().getModuleName() + " expected: " + moduleName);
	    ++exitCode;
	}

	if (r.getConfiguration().getGroupId() != groupID) {
	    System.err.println("GroupId not equal. Got: " + r.getConfiguration().getGroupId() + " expected: " + groupID);
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(5).getCalFactor() != chip5CalFactor) {
	    System.err.println("chip5CalFactor not equal. Got: " + r.getConfiguration().getChipConfiguration(5).getCalFactor() + " expected: " + chip5CalFactor);
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(4).getTrimTarget() != chip4Target) {
	    System.err.println("chip4Target not equal. Got: " + r.getConfiguration().getChipConfiguration(4).getTrimTarget() + " expected: " + chip4Target);
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(11).getThreshold() != chip11Threshold) {
	    System.err.println("chip11Threshold not equal. Got: " + r.getConfiguration().getChipConfiguration(11).getThreshold() + " expected: " + chip11Threshold);
	    ++exitCode;    
	}	
	if (r.getConfiguration().getChipConfiguration(0).getTrim(0) != chip0Chan0Trim) {
	    System.err.println("chip0Chan0Trim not equal. Got: " + r.getConfiguration().getChipConfiguration(0).getTrim(0) + " expected: " + chip0Chan0Trim);
	    ++exitCode;    
	}
	
	if (r.getPoints().getNPoints() != nPoints) {
	    System.err.println("nPoints not equal. Got: " + r.getPoints().getNPoints() + " expected: " + nPoints);
	    ++exitCode;        
	}
	if (r.getPoints().getPoint(0) != point0) {
	    System.err.println("point0 not equal. Got: " + r.getPoints().getPoint(0) + " expected: " + point0);
	    ++exitCode;        
	}
	
	if (r.getData().binHeight(0, 0) != bin00) {
	    System.err.println("bin00 not equal. Got: " + r.getData().binHeight(0, 0) + " expected: " + bin00);
	    ++exitCode; 
	}
	if (r.getData().binHeight(768+49, 30) != bin4930) {
	    System.err.println("bin4930 not equal. Got: " + r.getData().binHeight(768+49, 30) + " expected: " + bin4930);
	    ++exitCode; 
	}
    }
    
    public void plot() {
	IAnalysisFactory af = IAnalysisFactory.create();
	ITree tree = af.createTreeFactory().create();            

	// Create an IPlotter 
	IPlotter iplotter = af.createPlotterFactory().create();  
	iplotter.show();
	iplotter.createRegion().plot(r.getData());
    }
    
        public static void main(String[] args) {
	CheckRaw cr = new CheckRaw();
	try {
	    cr.runNumber = 1047;
	    cr.scanNumber = 6;
	    cr.moduleName = "20220330200015";
	    cr.groupID = 0;
	    cr.chip5CalFactor = 1.0f;
	    cr.chip4Target = 38;
	    cr.chip11Threshold = 38;
	    cr.chip0Chan0Trim = 2;	
	    cr.nPoints = 57;
	    cr.point0 = 60;	
	    cr.bin00 = 1000;	
	    cr.bin4930 = 209;
	    cr.compare("EventData.SctData::RawScanResult.1047.6.20220330200015");
	
	    cr.runNumber = 1048;
	    cr.scanNumber = 16;
	    cr.moduleName = "20220330200015";
	    cr.groupID = 0;
	    cr.chip5CalFactor = 1.0f;
	    cr.chip4Target = 38;
	    cr.chip11Threshold = 38;
	    cr.chip0Chan0Trim = 2;	
	    cr.nPoints = 57;
	    cr.point0 = 60;	
	    cr.bin00 = 1000;	
	    cr.bin4930 = 209;
	    cr.compare("EventData.SctData::RawScanResult.1048.16.20220330200015");
	    
	    /*cr.runNumber = 0;
	    cr.scanNumber = 2;
	    cr.moduleName = "20220170100053";
	    cr.groupID = 0;
	    cr.chip5CalFactor = 1.0f;
	    cr.chip4Target = 0;
	    cr.chip11Threshold = -56;
	    cr.chip0Chan0Trim = 7;	
	    cr.nPoints = 32;
	    cr.point0 = 0;	
	    cr.bin00 = 0;	
	    cr.bin4930 = 0;
	    cr.compare("EventData.SctData::RawScanResult.0.2.20220170100053");
	    
	    cr.runNumber = 1;
	    cr.scanNumber = 1;
	    cr.moduleName = "20220170100053";
	    cr.groupID = 0;
	    cr.chip5CalFactor = 1.0f;
	    cr.chip4Target = 0;
	    cr.chip11Threshold = 40;
	    cr.chip0Chan0Trim = 7;	
	    cr.nPoints = 64;
	    cr.point0 = 0;	
	    cr.bin00 = 0;	
	    cr.bin4930 = 200;
	    cr.compare("EventData.SctData::RawScanResult.1.1.20220170100053");
	    
	    
	    cr.runNumber = 1;
	    cr.scanNumber = 3;
	    cr.moduleName = "20220170100053";
	    cr.groupID = 0;
	    cr.chip5CalFactor = 1.0f;
	    cr.chip4Target = 0;
	    cr.chip11Threshold = 40;
	    cr.chip0Chan0Trim = 7;	
	    cr.nPoints = 64;
	    cr.point0 = 0;	
	    cr.bin00 = 0;	
	    cr.bin4930 = 1000;
	    cr.compare("EventData.SctData::RawScanResult.1.3.20220170100053");
	    
	    
	    cr.runNumber = 1;
	    cr.scanNumber = 4;
	    cr.moduleName = "20220170100028";
	    cr.groupID = 2;
	    cr.chip5CalFactor = 1.0f;
	    cr.chip4Target = 0;
	    cr.chip11Threshold = 40;
	    cr.chip0Chan0Trim = 4;	
	    cr.nPoints = 64;
	    cr.point0 = 0;	
	    cr.bin00 = 0;	
	    cr.bin4930 = 995;
	    cr.compare("EventData.SctData::RawScanResult.1.4.20220170100028");	   
	    */
	} catch (Exception e) {
	    e.printStackTrace();
	    System.exit(2);
	}
	
	if (args.length > 0) cr.plot();
	else System.exit(cr.exitCode);
    }

}

