#include "TimeWalkSummaryWriter.h"
#include "SctData/TimeWalkTestResult.h"
#include "SummaryManager.h"
#include <iomanip>

namespace SctData {
    namespace TestSummary{
	void TimeWalkSummaryWriter::write(const TestResult& t, std::ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    const TimeWalkTestResult& result  = dynamic_cast<const TimeWalkTestResult&>(t);
	    out << ios::fixed;
	    
	    out << "#\n%TimeWalkTest\n#\n";

	    out << "#\n#TW\n#\n#";
	    for (unsigned ichip=0; ichip<nChipLink; ichip+=1){
		out << getChipName(ichip) << "\t"; 
	    }
	    out << endl;
	    for (unsigned ichip=0; ichip<nChipLink; ichip+=1){
		out << setprecision(3) << result.getChipResult(ichip).timewalk << "\t"; 
	    }
	    out << "\n#\n#";
	    for (unsigned ichip=nChipLink; ichip<nChipModule; ichip+=1){
		out << getChipName(ichip) << "\t"; 
	    }
	    out << endl;
	    for (unsigned ichip=nChipLink; ichip<nChipModule; ichip+=1){
		out << setprecision(3) << result.getChipResult(ichip).timewalk << "\t"; 
	    }
	    out << "\n#\n#TCAL\n#";
	    for (unsigned ichip=0; ichip<nChipLink; ichip+=1){
		out << getChipName(ichip) << "\t"; 
	    }
	    out << endl;
	    for (unsigned ichip=0; ichip<nChipLink; ichip+=1){
		out << setprecision(3) << result.getChipResult(ichip).calibration << "\t"; 
	    }
	    out << "\n#\n#";
	    for (unsigned ichip=nChipLink; ichip<nChipModule; ichip+=1){
		out << getChipName(ichip) << "\t"; 
	    }
	    out << endl;
	    for (unsigned ichip=nChipLink; ichip<nChipModule; ichip+=1){
		out << setprecision(3) << result.getChipResult(ichip).calibration << "\t";
	    }
	    out << "\n#" << endl;

	    SummaryWriter::write(t.getDefects(), out);
	}

	bool TimeWalkSummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::TimeWalkTestResult", shared_ptr<SummaryWriter>(new TimeWalkSummaryWriter()));
    }
}
