#include "SummaryManager.h"
#include "SummaryWriter.h"
#include "SctData/TestResult.h"
#include "Sct/SctNames.h"
#include "Sct/IoExceptions.h"
#include "Sct/LogicErrors.h"
#include <sstream>
#include <iomanip>
#include <cstdlib>
#include <boost/date_time/posix_time/posix_time.hpp>

using namespace Sct;
using namespace boost;
using namespace std;

namespace SctData {
    namespace TestSummary{
	using boost::shared_ptr;

	SummaryManager::SummaryManager() {}

	SummaryManager::~SummaryManager() {}

	SummaryManager& SummaryManager::instance() throw () {
	    static SummaryManager bertha;
	    return bertha;
	}

	string SummaryManager::write(const TestResult& t) throw(IoError, LogicError) {
	    ostringstream oss;
	    write(t, oss);
	    return oss.str();
	}
	
	void SummaryManager::write(const TestResult& t, ostream& stream) throw(IoError, LogicError) {
	    shared_ptr<const SummaryWriter> writer = getWriter(t.getClassName());
	    writer->writeHeader(t, stream);
	    writer->write(t, stream);
	}
	
/*	shared_ptr<ofstream> SummaryManager::getOutputFileStream(const string& modulename) const throw(Sct::IoError, Sct::LogicError) {
	    using namespace boost::gregorian;
	    std::ostringstream os;
	    os << SctNames::getTempDir() << "/" << modulename << "_" << to_iso_string( date(day_clock::local_day() ) ) << ".txt" ;
	    cout << "SummaryManager opening file " << os.str() << endl;
	    shared_ptr<ofstream> file ( new ofstream( os.str().c_str() , ios::app ) );
	    if (!file->is_open() ) throw FileException(os.str(), "SummaryManager can't open file", __FILE__, __LINE__);
	    return file;
	}
	*/
	shared_ptr<const SummaryWriter> SummaryManager::getWriter(const string& classname) const throw(Sct::LogicError) {
	    WriterMap::const_iterator it = theMap.find(classname);
	    if ( it == theMap.end() ){
		cerr << "SummaryManager::getWriter no writer for " << classname << endl;
		cerr << "known writers:" << endl ;
		for (WriterMap::const_iterator it = theMap.begin(); it != theMap.end(); ++it){
		    cerr << (*it).first << endl;
		}
		throw InvalidArgumentError( string("SummaryManager::getWriter no writer for ") + classname, __FILE__, __LINE__ );
	    } else {
		return (*it).second ;
	    }
	}

	bool SummaryManager::addWriter(const string& testname, shared_ptr<SummaryWriter> writer) throw(Sct::LogicError) {
	    if (theMap.find(testname) == theMap.end() ){
		theMap[testname] = writer;
		return true;
	    }
	    return false;
	}

    } // end of namespace TestSummary
} // end of namespace SctData
