// For gcc296 floor
#include <cmath>

#include "SummaryManager.h"
#include "StrobeDelaySummaryWriter.h"
#include "SctData/StrobeDelayTestResult.h"

namespace SctData {
    namespace TestSummary{
	using namespace std;

	void StrobeDelaySummaryWriter::write(const TestResult& t, ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    const StrobeDelayTestResult& result  = dynamic_cast<const StrobeDelayTestResult&>(t);

	    out << "#\n%StrobeDelay\n#\n#DELAY\n#";
	    for (unsigned ichip=0; ichip<nChipLink; ++ichip){
		out << getChipName(ichip) << " ";
	    }
	    out << endl;
	    for (unsigned ichip=0; ichip<nChipLink; ++ichip){
		out << static_cast<int>(floor( result.getOptimum(ichip) + 0.5)) << " ";
	    }

	    out << "\n#";
	    for (unsigned ichip=nChipLink; ichip<nChipModule; ++ichip){
		out << getChipName(ichip) << " ";
	    }
	    out << endl;
	    for (unsigned ichip=nChipLink; ichip<nChipModule; ++ichip){
		out << static_cast<int>(floor( result.getOptimum(ichip) + 0.5)) << " ";
	    }
	    out << "\n#" << endl;

	    SummaryWriter::write(result.getDefects(), out);
	    
	}

	bool StrobeDelaySummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::StrobeDelayTestResult", shared_ptr<SummaryWriter>(new StrobeDelaySummaryWriter()));
    }
}
