#include "RawDisplayer.h"
#include "DisplayManager.h"
#include "DisplayInfo.h"

#include "SctData/ModuleConfiguration.h"
#include "SctData/ResultHeader.h"
#include "SctData/ConfigurationVariable.h"
#include "SctData/RawScanResult.h"
#include "SctData/OccupancyProjector.h"
#include "SctData/ModuleElement.h"
#include "SctData/DefaultVariable.h"
#include "ScanResultWriter/dataTypes.h"
#include "CommonWithDsp/ABCD/ABCDscans.h"
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TApplication.h>

#include <iostream>
#include <vector>
#include <boost/lexical_cast.hpp>

using namespace Sct;
using namespace SctData;
using namespace boost;

namespace SctDataDisplay {
    

class RawDisplayData : public DisplayData {
public:
    vector<shared_ptr<TCanvas> > canvas;
    shared_ptr<const RawScanResult> scan;
    vector<shared_ptr<TH1> > histos;
};     

bool RawDisplayer::inMap = DisplayManager::addToMap("SctData::RawScanResult", shared_ptr<Displayer>(new RawDisplayer()));
    
shared_ptr<DisplayData> RawDisplayer::display(shared_ptr<const Sct::Serializable> serial, const DisplayInfo& info, std::ostream& os) {
    
    shared_ptr<RawDisplayData> data (new RawDisplayData());
    data->scan = dynamic_pointer_cast<const RawScanResult>(serial);
    
    //cout << "Scan: " << endl;
    const ConfigurationVariable& var = data->scan->getHeader().getVariable();
    //cout << "Variable: " << var.getVariableName() << "  Strategy: " << var.getStrategyDescription() << endl;
    //cout << data->scan->getUniqueID() << endl ;
    //cout << data->scan->getHeader().getScanNumber() << endl << data->scan->getHeader().getRunNumber() << endl << data->scan->getHeader().getModuleName() << endl;
    
    //const ScanPoints& s = data->scan->getPoints();    
    //for (unsigned int i=0; i<s.getNPoints(); ++i) {
	//cout << s.getPoint(i) << "  " << s.getNEvents(i) << endl;
    //}
    //cout << endl;
    
    string name = var.getVariableName() + data->scan->getUniqueID();
    shared_ptr<TCanvas> c = createCanvas(name, name);
    data->canvas.push_back(c);
    c->Divide(1,2);
    for (int ilink=0; ilink<2; ++ilink){
      c->cd(ilink+1);
      data->scan->getScanData(ilink).SetMinimum(0.);
      string x_title;
      switch(data->scan->getDataType()) {
      case SR_DT_RAWHIST: { x_title="Raw Data"; break;}
      case SR_DT_SLICE: case SR_DT_SLICE_COMPRESSED: { x_title="Channel"; break;}
      }
      data->scan->getScanData(ilink).SetXTitle(x_title.c_str());
      data->scan->getScanData(ilink).SetYTitle(var.getVariableName().c_str());
      data->scan->getScanData(ilink).SetStats(false);
      data->scan->getScanData(ilink).Draw("colz");
    }
    
    if (data->scan->getDataType() != SR_DT_RAWHIST  && 
	var != *DefaultVariable::instance(ST_NMASK) &&
	var != *DefaultVariable::instance(ST_TOKEN) &&
	info.displayChannels.size() + info.displayChips.size() != 0) {
      displayProjs(info, *data);
    }

    return data;
}
    
void RawDisplayer::displayProjs(const DisplayInfo& info, RawDisplayData& data) {
    unsigned int nMax = min((unsigned int)25, info.displayChannels.size() + info.displayChips.size());
    unsigned int j=0;
    shared_ptr<TCanvas> c;
    
    //Now show some projections for channels and chips
    OccupancyProjector occ(*data.scan);

    for (unsigned int i=0; i<info.displayChips.size(); ++i, ++j) {
	if (j%nMax == 0) {
	    c = createCanvas("Projections", "Projections for module " + data.scan->getHeader().getModuleName());
	    data.canvas.push_back(c);
	    divideCanvas(nMax, *c);
            j=0;
        }
	c->cd(j+1);
	
	string name = "chip" + lexical_cast<string>(info.displayChips[i]) + data.scan->getUniqueID();
	auto_ptr<TH1> chip = occ.getOccupancy(name.c_str(), ModuleElement::Chip(info.displayChips[i]));
	chip->Draw();
	data.histos.push_back(shared_ptr<TH1>(chip));
    }
    
    
    for (unsigned int i=0; i<info.displayChannels.size(); ++i, ++j) {
	if (j%nMax == 0) {
	    c = createCanvas("Projections", "Projections for module " + data.scan->getHeader().getModuleName());
	    data.canvas.push_back(c);
	    divideCanvas(nMax, *c);
            j=0;
        }
	c->cd(j+1);
	
	string name = "channel" + lexical_cast<string>(info.displayChannels[i]) + data.scan->getUniqueID();
	auto_ptr<TH1> channel = occ.getOccupancy(name.c_str(), ModuleElement::Channel(info.displayChannels[i]));
	channel->Draw();
	data.histos.push_back(shared_ptr<TH1>(channel));
    }
}   
}
