#ifndef SCTDATADISPLAY_DISPLAYER_H
#define SCTDATADISPLAY_DISPLAYER_H

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

using boost::shared_ptr;
using std::string;

namespace Sct {
    class Serializable;
}

namespace SctData {
    class DefectList;
}

class TCanvas;



namespace SctDataDisplay {
 
class DisplayInfo;


/**
  This class exists as a holder for sub-classes.
  Displayers that need data not to get deleted should put it all in a sub-class 
  of one of these.  It will get deleted when then display is not needed.
  */
class DisplayData {
};


/**
  This class is an interface to classes that can show Serializable objects.
  It also contains helper methods.
  @author Matthew Palmer
  */
class Displayer {
public:
  Displayer() {}
    /**
      Should display components listed in info of the data object
      @throws Any Sct::Exception
      */
    virtual shared_ptr<DisplayData> display(shared_ptr<const Sct::Serializable> data, const DisplayInfo& info, std::ostream& os) = 0;
    
protected:           
    /**
      Creates a new TCanvas using some strings
      */
    static shared_ptr<TCanvas> createCanvas(string name, string title);
    
    /**
      Arranges n objects on a TCanvas
      */
    static void divideCanvas(unsigned int n, TCanvas& canvas);
    
    /**
      Prints a defect list to stdout
      */
    void printDefectList(const SctData::DefectList& list, std::ostream& os);

};


/**
This class represents a Displayer that may be able to display many different types of data
*/
class GenericDisplayer : public virtual Displayer {
public:
    /** 
       If the displayer can display the given object, then it should return true
       It should not do the display!
       @note nothrow
    */
    virtual bool canDisplay(const Sct::Serializable& ob) = 0;

};

}

#endif //SCTDATADISPLAY_DISPLAYER_H
