#ifndef SCTAPI_MARSHALLING_H
#define SCTAPI_MARSHALLING_H

#include <vector>

Sct_SctApi_T_BOCChannelList copyBOCChannelConfigVectorToILU(const std::vector<SctConfiguration::BOCChannelConfig> &configList) {
  Sct_SctApi_T_BOCChannelList result;
  result = _Sct_SctApi_T_BOCChannelList_sequence::Create(4, NULL);
  result->Clear(0);

  for(unsigned long i=0; i<configList.size(); i++) {
    const SctConfiguration::BOCChannelConfig &config = configList[i];

    sctConf_T_BOCChannelConfig *res = new sctConf_T_BOCChannelConfig;
    res->current = config.current;
    res->delay = config.delay;
    res->markSpace = config.markSpace;

    res->threshold0 = config.threshold0;
    res->delay0 = config.delay0;

    res->threshold1 = config.threshold1;
    res->delay1 = config.delay1;
    result->Append(res);
  }

  return result;
}

Sct_SctApi_T_AutoResultList copyAutoResultListToILU(const std::list< ::SctApi::AutoConf::AutoResult> &autoList) {
  Sct_SctApi_T_AutoResultList result;
  result = _Sct_SctApi_T_AutoResultList_sequence::Create(4, NULL);
  result->Clear(0);

  for(std::list< ::SctApi::AutoConf::AutoResult>::const_iterator autoIter = autoList.begin();
      autoIter != autoList.end(); autoIter ++) {
    const ::SctApi::AutoConf::AutoResult &autoResult = *autoIter;

    Sct_SctApi_T_AutoConfigResult *res = new Sct_SctApi_T_AutoConfigResult;
    res->partition = autoResult.partition;
    res->crate = autoResult.crate;
    res->rod = autoResult.rod;

    res->tx = autoResult.tx;
    res->rx = autoResult.rx;

    result->Append(res);
  }

  return result;
}

template <typename ILUBlock, typename ArrayMember>
inline std::vector<ArrayMember> copyILUToVector(ILUBlock thisSeq) {
  std::vector<ArrayMember> array;

  for(unsigned int i=0; i<thisSeq->Length(); i++) {
    array.push_back(thisSeq->Nth(i));
  }

  return array;
}

Sct_SctApi_T_NameValueList copyMapToNameValueList(std::map<std::string, float> myNameValues) {
  Sct_SctApi_T_NameValueList result;

  result = _Sct_SctApi_T_NameValueList_sequence::Create(4, NULL);
  result->Clear(0);

  for(std::map<std::string, float>::const_iterator iter=myNameValues.begin(); 
      iter != myNameValues.end(); 
      iter++) {
    Sct_SctApi_T_NameValue *member = new Sct_SctApi_T_NameValue;

    char *copy = (char *)malloc((iter->first.length()+1) * sizeof(char));
    strncpy(copy, iter->first.c_str(), iter->first.length());
    copy[iter->first.length()] = 0;

    member->name = copy;
    member->value = iter->second;

    result->Append(member);
  }

  return result;
}

#endif
