#include <ipc/object.h>
#include <ipc/server.h>
#include <boost/shared_ptr.hpp>
#include <pmg/pmg_initSync.h>

#include "SctApi/SctApi.h"
#include "sctConf/configipc.h"

#include "SctApiServer.h"

std::auto_ptr<IPCServer> ipcServer; 

void pmgSynch(void *) {
    pmg_initSync();
}

int main(int argc, char** argv) 
{
  IPCCore::init(true, false); // Try reentrant for DDC IS callbacks
  IPCPartition p("SCT");
  ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));
  try {    
    std::auto_ptr<SctApi::SctApi> api(new SctApi::SctApi(boost::shared_ptr<SctConfiguration::Configuration>(new SctConfiguration::ConfigIPC)));
    std::auto_ptr<SctApiServer> h(new SctApiServer(*api, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

    // Try publishing it
    if (!h->publish()) {
      std::cout << "Failed to publish SctApi" << std::endl;
      return 0;
    } 

    std::cout << "Serving...\n";

    ipcServer->doSoon(pmgSynch, NULL);
    ipcServer->run();
    std::cout << "Run over" << std::endl;
    h->withdraw();
//    delete ipcServer;
  } catch(SctConfiguration::ConfigurationException &c) {
    std::cout << "ConfigurationException: " << c.what() << std::endl;

    MRSStream mrsStream(p);
    mrsStream << "SCTAPI_FAIL" << MRS_FATAL << MRS_QUALIF("SctApiServer") << MRS_TEXT("Configuration server not running!") << ENDM;
    
    exit(1);
  }
}

