#ifndef SCTAPI_PRIMLISTWRAPPER_HEADER
#define SCTAPI_PRIMLISTWRAPPER_HEADER

#include <memory>
#include <list>

namespace SctPixelRod {
  class RodPrimList;
  class RodPrimitive;
}

namespace SctApi {
  struct PrimListWrapper {
    PrimListWrapper();
    PrimListWrapper(unsigned int index);
    void clear();

    /// Add primitive to list
    /**
       If data is non zero then delete memory at end of life
     */
    void addPrimitive(const SctPixelRod::RodPrimitive &prim, long *data = 0);

    /// Add primitive to the list, using constant data
    /**
       Copy and keep data to end of life

       @param length Length of data (ie primLength - 4)
       @param index  Id of primitive in primList
       @param prim   Primitive identifier
       @param rev    Primitive revision number
       @param data   Contents of primitive
     */
    void addPrimitive(long length, long index, long prim, long rev, const long *data);

    ~PrimListWrapper();

    std::auto_ptr<SctPixelRod::RodPrimList> list;
    std::list<long *> data;
  };
}

#endif
