#ifndef SCTTEST_XMLSUMMARYFILE_H
#define SCTTEST_XMLSUMMARYFILE_H

#include <string>
#include <fstream>

using std::string;
using std::ifstream;

namespace SctTest {

struct XmlSummaryRecord {
    string serialNumber;
    string xmlFile;
};

/**
 Represents the summary file.  Provides simple access to data.
 All operations may throw Sct::IoExceptions
 @author Matthew Palmer
 */
class XmlSummaryFile {
public:
    XmlSummaryFile(string fileName);
    bool hasMoreRecords();
    XmlSummaryRecord getNextRecord();

private:
    ifstream file;
};
}

#endif //SCTTEST_XMLSUMMARYFILE_H
