#ifndef SCTTEST_SCANINFO_H
#define SCTTEST_SCANINFO_H

#include <string>
#include <boost/shared_ptr.hpp>
#include <cmath>
#include "CommonWithDsp/sctStructure.h"
#include "CommonWithDsp/ABCD/ABCDscans.h"

using std::string;
using std::fabs;
using boost::shared_ptr;

namespace SctTest {
class ScanInfo {
public:    
    bool operator<(const ScanInfo& s2) const {
	return serialNum < s2.serialNum || scanVar < s2.scanVar;
    }
    
    string serialNum;
    unsigned short scanVar;
};

class ThresholdScanDetails {
public:
    ThresholdScanDetails() {}
    ThresholdScanDetails(const ABCDModule& config);
    
    bool operator==(const ThresholdScanDetails& s2) const {	
	return fabs(charge - s2.charge) < 0.1 && range == s2.range && trims == s2.trims;
    }
    
    double charge;
    int range;
    int trims;
    string fileName;
};

class StrobeDelayScanDetails {
public:
    StrobeDelayScanDetails() {}
    StrobeDelayScanDetails(const ABCDModule& config);
    
    bool operator==(const StrobeDelayScanDetails& s2) const {	
	return fabs(charge - s2.charge) < 0.1 && fabs(threshold - s2.threshold) < 0.1;
    }
    
    double charge;
    double threshold;
    string fileName;
};


}


#endif //SCTTEST_SCANINFO_H
