#include "Exceptions.h"

namespace SctTest {

SctTestException::SctTestException(const string& msg, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::SctTestException", msg, 0, file, line);
}

SctTestException::SctTestException(Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::SctTestException", "", &cause, file, line);
}

SctTestException::SctTestException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::SctTestException", msg, &cause, file, line);
}


NoDataFileException::NoDataFileException(const string& msg, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::NoDataFileException", msg, 0, file, line);
}

NoDataFileException::NoDataFileException(Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::NoDataFileException", "", &cause, file, line);
}

NoDataFileException::NoDataFileException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::NoDataFileException", msg, &cause, file, line);
}


DataNotValidException::DataNotValidException(const string& msg, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::DataNotValidException", msg, 0, file, line);
}

DataNotValidException::DataNotValidException(Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::DataNotValidException", "", &cause, file, line);
}

DataNotValidException::DataNotValidException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::DataNotValidException", msg, &cause, file, line);
}



NoDataException::NoDataException(const string& msg, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::NoDataException", msg, 0, file, line);
}

NoDataException::NoDataException(Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::NoDataException", "", &cause, file, line);
}

NoDataException::NoDataException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw() {
    initialize("SCT_TEST", "SctTest::NoDataException", msg, &cause, file, line);
}


}
