#include "Configuration.h"
#include "ScanMap.h"
#include "Sct/Env.h"
#include "Sct/IoExceptions.h"
#include "Sct/ILUMarshalling.h"
#include "Sct_SctApi/SctApiServer.h"

using namespace Sct;

namespace SctTest {

Configuration::Configuration() : IPCObject(SctTestApi_C_Configuration_instanceName, ipcServer.get()){
    try {
	setDataFile("${SCT_DAQ_ROOT}/installed/config/TestConfig/ModuleData.txt");
    } catch (Sct::FileException& fe) {
        fe.sendToMrs(MRS_INFORMATION);
    }
    setFastTimes();
    //setRealisticTimes();
}

Configuration& Configuration::instance() {
    static Configuration configuration;
    return configuration;
}

void Configuration::setDataFile(string file) {
    string temp = Env::substituteVariables(file);
    ScanMap::instance().initialize(temp);
    dataFile = temp;
}

string Configuration::getDataFile() const {
    return dataFile;
}

void Configuration::setFastTimes() {
    setScanTime(5);
    setReadoutTime(1);
    setMultiDspEfficiency(1);
}

void Configuration::setRealisticTimes() {
    setScanTime(30);
    setReadoutTime(1);
    setMultiDspEfficiency(0.9);
}

void Configuration::setScanTime(unsigned int time) {
    scanTime = time;
}

unsigned int Configuration::getScanTime() const {
    return scanTime;
}

void Configuration::setMultiDspEfficiency(double efficiency) {
    dspEfficiency = efficiency;
}

double Configuration::getMultiDspEfficiency() const {
    return dspEfficiency;
}

void Configuration::setReadoutTime(unsigned int time) {
    readoutTime = time;
}

unsigned int Configuration::getReadoutTime() const {
    return readoutTime;
}

//ILU methods:
void Configuration::setDataFile (SctTestApiStatus *_status, ilu_T_CString file) {
    try {
        setDataFile(file);
    } catch (Sct::FileException& e) {
        _status->returnCode = SctTestApi_E_NoSuchFileException;
    }
}

ilu_T_CString Configuration::getDataFile (SctTestApiStatus *_status) {
    return copyStringToILU(getDataFile());
}

void Configuration::setFastTimes (SctTestApiStatus *_status) {
    setFastTimes();
}

void Configuration::setRealisticTimes (SctTestApiStatus *_status) {
    setRealisticTimes();
}

void Configuration::setScanTime (SctTestApiStatus *_status, ilu_Integer time) {
    setScanTime(time);
}

ilu_Integer Configuration::getScanTime (SctTestApiStatus *_status) {
    return getScanTime();
}

void Configuration::setMultiDspEfficiency (SctTestApiStatus *_status, ilu_Real efficiency) {
    setMultiDspEfficiency(efficiency);
}

ilu_Real Configuration::getMultiDspEfficiency (SctTestApiStatus *_status) {
    return getMultiDspEfficiency();
}

void Configuration::setReadoutTime (SctTestApiStatus *_status, ilu_Integer time) {
    setReadoutTime(time);
}

ilu_Integer Configuration::getReadoutTime (SctTestApiStatus *_status) {
    return getReadoutTime();
}

}
