#include <TH1.h>
#include <TH2.h>
#include <iostream>
#include "SctData/RawScanResult.h"
#include "SctData/ModuleConfiguration.h"
#include "SctData/ScanPoints.h"
#include "SctData/ResultHeader.h"
#include "SctData/ConfigurationVariable.h"
#include "SctData/mVThresholdVariable.h"
#include "Sct/SctNames.h"
#include "Sct/SctParameters.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/IS/IONameIS.h"

using namespace SctData;
using namespace Sct;
using namespace Sct::IS;
/**
 * This is a simple test program that creates a RawScanResult object and publishes it to an IS server.
 * The API is very likely to change and this may become obsolete quickly.
 */
int main(int argc, char** argv) {
    setExceptionHandlers(argv[0]);
    
    //RawScanResult owns its scans..must be newed
    TH2D* scan0 = new TH2D("Scan0","Scan",nChannelLink,-3,3, 64, 0, 3);
    scan0->FillRandom("gaus",10000);
    TH2D* scan1 = new TH2D("Scan1","Scan",nChannelLink,-3,3, 64, 0, 3);
    scan1->FillRandom("gaus",10000);

    scan0->SetBinContent(1, 1, 1000);
    scan1->SetBinContent(50, 50, 2000);
    cout << "Created hists" << endl;

    //Create the scanheader
    ResultHeader s(100, 1000, "TestSubmit", mVThresholdVariable::instance());

    cout << "Created scan" << endl;

    //Create the module configuration
    ModuleConfiguration m;
    m.setGroupId((char)4);
    m.getChipConfiguration(5).setCalFactor(5.3f);
    m.getChipConfiguration(4).setTrimTarget((char)20);
    m.getChipConfiguration(11).setThreshold((char)123);
    m.getChipConfiguration(0).setTrim(0, (char)15);
    
    cout << "Created module config" << endl;

    ScanPoints pts;
    for (int i=0; i<64; ++i) {
        pts.addPoint(13.5*(i+1), 1000, 0);
    }

    //Create a RawRODData object
    RawScanResult r(s, m, pts, *scan0, *scan1);

    cout << "Created RawScanResult" << endl;

    IOParamsIS p(SctNames::getEventDataName());
    IOManagerIS::instance().write(r, &p);

    //All done!  Quit...
    cout << "All done!" << endl;
    return 0;
}
