#ifndef MVTHRESHOLDVARIABLE_H
#define MVTHRESHOLDVARIABLE_H

#include <string>
#include "Sct/round.h"
#include "ThresholdVariable.h"

using std::string;
using namespace Sct;

namespace SctData {
    
class mVThresholdVariable : public ThresholdVariable {
public:
    static const mVThresholdVariable& instance() throw();
    
    virtual double getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual double getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    virtual double getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw();    
    virtual double getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw();   
     
private:
    mVThresholdVariable();
    unsigned char getActualPoint(double logicalPt) const throw();
    double getLogicalPoint(unsigned char actualPt) const throw();
};

///To get mV from DAC, multiply by 2.5
inline unsigned char mVThresholdVariable::getActualPoint(double logicalPt) const throw() {    
    return roundToUChar(logicalPt/2.5);
}

inline double mVThresholdVariable::getLogicalPoint(unsigned char actualPt) const throw() {
    return 2.5 * actualPt;
}


}

#endif //#ifndef MVTHRESHOLDVARIABLE_H
