#include "SingleVariableTestResult.h"
#include "NullVariable.h"

#include "Sct/LogicErrors.h"
#include "Sct/OutOfRangeError.h"

using namespace Sct;

namespace SctData {

SingleVariableTestResult::SingleVariableTestResult() throw() : m_optima(nChipModule){
}
  
SingleVariableTestResult::SingleVariableTestResult(const ConfigurationVariable& scanVariable, const unsigned int runNumber, const string& moduleName) throw() 
    : TestResult(runNumber, moduleName, NullVariable::instance(), scanVariable), m_optima(nChipModule){
}

void SingleVariableTestResult::addScan(unsigned int scanNumber, double testPoint) throw (LogicError) {
    if (data.size() != 0) throw InvariantViolatedError("SingleVariableTestResult::addScan - can only contain 1 scan", __FILE__, __LINE__);
    TestResult::addScan(scanNumber, testPoint);
}

double SingleVariableTestResult::getOptimum(unsigned i) const throw(LogicError) {
    if (i>=nChipModule)
        throw OutOfRangeError<unsigned>("SingleVariableTestResult::getOptimum", __FILE__, __LINE__, i,0,nChipModule-1);
    return m_optima[i];
}


    void SingleVariableTestResult::setOptimum(unsigned int chip, double optimum) throw(Sct::LogicError) {
	if (chip>=nChipModule)
	    throw OutOfRangeError<unsigned>("SingleVariableTestResult::setOptimum", __FILE__, __LINE__,chip,0,nChipModule-1);
	m_optima[chip] = optimum;    
}
}
