#include "Sct/IoExceptions.h"

#include "../TrimRangeTestResult.h"
#include "TrimRangeTestResult_ChipTrimStreamer_v1.h"

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TrimRangeTestResult_ChipTrimStreamer_v1::s_version=1;

TrimRangeTestResult_ChipTrimStreamer_v1::TrimRangeTestResult_ChipTrimStreamer_v1() throw() {}

bool TrimRangeTestResult_ChipTrimStreamer_v1::inMap = IOManager::addToMap("SctData::TrimRangeTestResult::ChipTrim",  auto_ptr<Streamer>(new TrimRangeTestResult_ChipTrimStreamer_v1()));


shared_ptr<Streamable> TrimRangeTestResult_ChipTrimStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new TrimRangeTestResult::ChipTrim());
    read(in, *ad, manager);
    return ad;
}

void TrimRangeTestResult_ChipTrimStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
  const TrimRangeTestResult::ChipTrim& trim = dynamic_cast<const TrimRangeTestResult::ChipTrim&> (ob);
  out << trim.target << (int) trim.range;
  if (trim.channelTrim.size()!=nChannelChip){
    ostringstream os;
    os << "TrimRangeTestResult_ChipTrimStreamer_v1::writeTrim, bad size " << trim.channelTrim.size();
    throw StreamCorruptedException(os.str(), __FILE__, __LINE__ );
  }
  out << (int) trim.channelTrim.size();
  for (unsigned i=0; i<trim.channelTrim.size(); ++i){
    Stat<TrimRangeTestResult::Trim> t=trim.channelTrim.getAt(i);
    int trim_i = t.value.trim;
    out << t.valid << trim_i << t.value.vthr;
  }
}

  void TrimRangeTestResult_ChipTrimStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError){
    TrimRangeTestResult::ChipTrim& trim = dynamic_cast<TrimRangeTestResult::ChipTrim&> (ob);
    in >> trim.target;
    int range; in >> range ; trim.range=range;
    int size; in >> size; trim.channelTrim.resize(size);
    if (size!=nChannelChip){
      ostringstream os;
      os << "TrimRangeTestResult_ChipTrimStreamer_v1::readTrim, bad size " << trim.channelTrim.size();
      throw StreamCorruptedException(os.str(), __FILE__, __LINE__ );
    }
    for (unsigned i=0; i<size; ++i){
      Stat<TrimRangeTestResult::Trim>& t=trim.channelTrim.modifyAt(i);
      int trim_i;
      in >> t.valid >> trim_i >> t.value.vthr;
      t.value.trim=trim_i;
    }
  }

}
}
