#include "TestResultStreamer_v3.h"
#include "../TestResult.h"
#include "../ConfigurationVariable.h"
#include "../DcsData.h"

#include <string>

using namespace std;
using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TestResultStreamer_v3::s_version=3;
	
bool TestResultStreamer_v3::inMap = IOManager::addToMap("SctData::TestResult",  std::auto_ptr<Streamer>(new TestResultStreamer_v3()));
	
TestResultStreamer_v3::TestResultStreamer_v3() throw() {}

shared_ptr<Streamable> TestResultStreamer_v3::read(IStream&, const IOManager&) const throw(LogicError, IoError) {
    throw Sct::LogicError("Cannot make a TestResult - abstract class",__FILE__,__LINE__);
}

void TestResultStreamer_v3::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    // cout <<"TestResultIS publishing"<<endl;
    const TestResult& mytest = dynamic_cast<const TestResult&>(ob);
    
    manager.writeImpl(out, mytest.getHeader(), false);
    manager.writeImpl(out, mytest.getTestVariable(), false);

    out << mytest.getNScans();
    for (unsigned int i=0; i<mytest.getNScans(); ++i) {
        out << mytest.getScanNumberAt(i) << mytest.getTestPointAt(i);
    }
    manager.writeImpl(out, mytest.getDefects() , false);
    
    out << mytest.getPassed();
    out << mytest.getProblem();
    vector<string> comments = mytest.getComments();
    out << comments.size();
    for (unsigned int i=0; i<comments.size(); ++i) {
	out << comments[i];
    }

    shared_ptr<const DcsData> dcs = mytest.getDcsData();

    out << (bool) dcs.get();
    if (dcs.get()) manager.writeImpl(out, *dcs, false);
}

void TestResultStreamer_v3::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {  
    TestResult& mytest = dynamic_cast<TestResult&>(ob);

    //cout << "TestResultIS refreshing" << endl;

    manager.readImpl(in, mytest.getHeader(), false);
    shared_ptr<Streamable> ob2 = manager.readImpl(in, "SctData::ConfigurationVariable");
    mytest.setTestVariable(*boost::dynamic_pointer_cast<ConfigurationVariable>(ob2));	///Should always succeed!
        
    //cout << "   found "<<runNumber << moduleName << endl;

    unsigned int size=0;
    in >> size;
    for (unsigned int i=0; i<size; ++i) {
        unsigned int scanNumber;
        double testPoint;
        in >> scanNumber >> testPoint;
        mytest.addScan(scanNumber, testPoint);
        //cout << "TestResultIS refresh : added scan "<<scanNumber<<endl;
    }
    manager.readImpl(in, mytest.getDefects(), false);
    
    bool passed, problem;
    unsigned int nComments;    
    string comment;
    in >> passed;   mytest.setPassed(passed);
    in >> problem;  mytest.setProblem(problem);
    
    in >> nComments;
    for (unsigned int i=0; i<nComments; ++i) {
	in >> comment;	mytest.addComment(comment);
    }
    
    bool hasDcs; in >> hasDcs;

    if (hasDcs) {
      shared_ptr<DcsData> dcs (new DcsData());
      manager.readImpl(in, *dcs, false);
      mytest.setDcsData(dcs);
    }
}
}
}

