#ifndef SCTDATA_IO_SCANPOINTSSTREAMER_H
#define SCTDATA_IO_SCANPOINTSSTREAMER_H

#include "Sct/Exception.h"
#include "Sct/Streamer.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

class Sct::OStream;
class Sct::IStream;
class Sct::Streamable;

using namespace Sct;

namespace SctData {
namespace IO {
/**
This class is an Streamer for reading/writing ScanPointss to/from IS.
*/
class ScanPointsStreamer_v1 : public virtual Streamer {
public:
	//Streamer_v1 overrides
	virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
	virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
	virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
 virtual unsigned getVersion() const throw() {return s_version;}

private:
	ScanPointsStreamer_v1() throw();				///< Constructor is private
    static unsigned s_version;
    static bool inMap;			///< The static dummy variable for the ISManager map
};
}
}
#endif //#ifndef SCTDATA_IO_SCANPOINTSSTREAMER_H
