#ifndef SCTDATA_IO_FITOBJECTIS_H
#define SCTDATA_IO_FITOBJECTIS_H

#include "Sct/Streamer.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

namespace SctData {
    
class FitObject;

namespace IO {
    
/**
This class is a Streamer for reading/writing FitObjects
*/	
class FitObjectStreamer_v1 : public virtual Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    virtual shared_ptr<Streamable> read(Sct::IStream&, const Sct::IOManager&) const throw(LogicError, IoError);
    virtual unsigned getVersion() const throw() {return s_version;}

protected:	
    ///Avoids dynamic_casting - faster!
    void read(IStream& in, SctData::FitObject& ob, const IOManager& manager) const throw(LogicError, IoError);    
    FitObjectStreamer_v1() throw() {}	///< Constructor is private
    
private:
    static unsigned s_version;
    static bool inMap;
};

//Now ISStreamer_v1s for all the different FitObjects

class ErfcFitObjectStreamer_v1 : public FitObjectStreamer_v1 {
public:    
    ///@todo: Needed to get round gcc295 bug
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);       
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);         
    virtual unsigned getVersion() const throw() {return s_version;}    
private:
    ErfcFitObjectStreamer_v1() throw() {}
    static unsigned s_version;
    static bool inMap;					///< The static dummy variable for the ISManager map
};

class ErfFitObjectStreamer_v1 : public FitObjectStreamer_v1 {
public:    
    ///@todo: Needed to get round gcc295 bug
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);       
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);         
   virtual unsigned getVersion() const throw() {return s_version;}
private:
    ErfFitObjectStreamer_v1() throw() {}
    static unsigned s_version;
    static bool inMap;					///< The static dummy variable for the ISManager map
};

class TopHatFitObjectStreamer_v1 : public FitObjectStreamer_v1 {
public:    
    ///@todo: Needed to get round gcc295 bug
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);       
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);         
       virtual unsigned getVersion() const throw() {return s_version;}
private:
    TopHatFitObjectStreamer_v1() throw() {}
    static unsigned s_version;
    static bool inMap;					///< The static dummy variable for the ISManager map
};

class GausFitObjectStreamer_v1 : public FitObjectStreamer_v1 {
public:    
    ///@todo: Needed to get round gcc295 bug
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);       
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);         
       virtual unsigned getVersion() const throw() {return s_version;}
private:
    GausFitObjectStreamer_v1() throw() {}
    static unsigned s_version;
    static bool inMap;					///< The static dummy variable for the ISManager map
};

}
}

#endif //SCTDATA_IO_FITOBJECTIS_H
