#include "ErfFitObject.h"
#include "FitFunctions.h"

#include <TMath.h>
#include <TH1.h>
#include <TF1.h>

using namespace Sct;

namespace SctData {

/**
  file static method to create vector of parameter names
  */
vector<string> ErfFitObject::createParNames() {
    vector<string> parNames(3);
    parNames[0] = "Prefact";
    parNames[1] = "Mean";
    parNames[2] = "Sigma";
    return parNames;
}

vector<string> ErfFitObject::parNames = ErfFitObject::createParNames();
    
ErfFitObject::ErfFitObject() : FitObject("erf", 3, parNames) {
}

ErfFitObject::ErfFitObject(const TF1& f) : FitObject("erf", 3, parNames, f) {
}

shared_ptr<FitObject> ErfFitObject::clone() const throw() {
    return shared_ptr<FitObject>(new ErfFitObject(*this));
}

ErfFitObject& ErfFitObject::operator= (const TF1& f) throw(LogicError) {
    this->FitObject::operator=(f);
    return *this;
}

// Call the appropriate constructor for making a ROOT TF1 object from this ErfFitObject::
auto_ptr<TF1> ErfFitObject::makeBasicRootTF1() const throw(LogicError) {
    auto_ptr<TF1> r( new ::TF1("myerf", erf, this->getVarMin(0), this->getVarMax(0), 3));
    if (!r.get())
        throw InvariantViolatedError("ErfFitObject::makeBasicRootTF1()", __FILE__, __LINE__);
    return r;
}

}  // end of namespace SctData

