#include "DefectList.h"
#include "DefectPrototype.h"
#include "Defect.h"

namespace SctData {

DefectList::DefectList() {}

string DefectList::getClassName() const throw() {
    return "SctData::DefectList";
}

void DefectList::addDefect(Defect defect) {
  DefectCollection::iterator i=defectList.begin();
  while(i!=defectList.end()){

    const ModuleElement& ei = (*i).getModuleElement();
    const ModuleElement& ej = defect.getModuleElement();
    const DefectPrototype& pi = (*i).getPrototype();
    const DefectPrototype& pj = defect.getPrototype();
    
    // if the defect is of the same type:
    if ( pi==pj ){
      // if new defect already contaned, then redundant:
      if ( ei.contains(ej) ) return;
      // if new defect contains existing one, replace:
      if ( ej.contains(ei) ) {
	*i=defect;
	return;
      }
      
      // if they overlap or are adjacent, replace with combined defect:
      if ( ei.overlaps(ej) || ei.adjacentTo(ej) ){
	unsigned first = ei.getFirst() < ej.getFirst() ? ei.getFirst() : ej.getFirst();
	unsigned last  = ei.getLast() > ej.getLast() ? ei.getLast() : ej.getLast();
	i=defectList.erase(i);
	defectList.push_back(Defect(pi,ModuleElement(first,last)));
	return;
      }
    }
    ++i;
  }
  defectList.push_back(defect);
}

const DefectList::DefectCollection& DefectList::getAllDefects() const {
    return defectList;
}

auto_ptr<DefectList> DefectList::getDefectsAffectingElement(ModuleElement element) const {
    auto_ptr<DefectList> newDefects(new DefectList());
    for (DefectCollection::const_iterator i=defectList.begin(); 
	 i!=defectList.end(); 
	 ++i) {
      if ( (*i).getModuleElement().overlaps(element))
	newDefects->addDefect(*i);
    }
    return newDefects;
}

DefectSeverity DefectList::defectSeverityAffectingElement(ModuleElement element) const {
    DefectSeverity s = NONE;
    for (DefectCollection::const_iterator i=defectList.begin(); 
	 i!=defectList.end(); 
	 ++i) {
        if ( (*i).getModuleElement().overlaps(element) && (*i).getPrototype().getSeverity() > s)
	  s = (*i).getPrototype().getSeverity();
    };
    return s;
}

auto_ptr<DefectList> DefectList::getDefectsEncompassingElement(ModuleElement element) const {
    auto_ptr<DefectList> newDefects(new DefectList());
    for (DefectCollection::const_iterator i=defectList.begin(); 
	 i!=defectList.end(); 
	 ++i) {
      if ( (*i).getModuleElement().contains(element))
	newDefects->addDefect(*i);
    }
    return newDefects;
}

DefectSeverity DefectList::defectSeverityEncompassingElement(ModuleElement element) const {
    DefectSeverity s = NONE;
    for (DefectCollection::const_iterator i=defectList.begin(); 
	 i!=defectList.end(); 
	 ++i) {
      if ((*i).getModuleElement().contains(element) && (*i).getPrototype().getSeverity() > s)
	s = (*i).getPrototype().getSeverity();
    };
    return s;
}
  
DefectList& DefectList::operator +=(const DefectList& toadd) {
    for (DefectCollection::const_iterator i=toadd.defectList.begin(); 
	 i!=toadd.defectList.end(); 
	 ++i) {
      if (!this->containsDefect(*i))
	this->addDefect(*i);
    }
    return *this;
}

bool DefectList::containsDefect(Defect defect) const {
  for (DefectCollection::const_iterator i=defectList.begin(); 
	 i!=defectList.end(); 
	 ++i) {
    if (*i == defect) return true;
  }
  return false;
}

}

