#include "DefaultVariable.h"

namespace SctData {

DefaultVariable::DefaultVariable(unsigned int typeRep) : ConfigurationVariable(typeRep, "Default Variable", "Default Variable") {}

shared_ptr<ConfigurationVariable> DefaultVariable::instance(unsigned int typeRep) {
    return ConfigurationVariableIOHelper::getFromTypeRep(typeRep);
}
    
//Conversions
double DefaultVariable::getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw() {
    return logicalPt;
}

double DefaultVariable::getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw() {
    return logicalPt;
}

double DefaultVariable::getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return logicalPt;
}

double DefaultVariable::getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw() {
    return actualPt;
}

double DefaultVariable::getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw() {
    return actualPt;
}

double DefaultVariable::getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return actualPt;
}

//ModuleConfiguration interaction
double DefaultVariable::getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw() {
    return 0;
}

void DefaultVariable::setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw() {}


}
