#include "DcsData.h"

namespace SctData{
  
  std::string DcsData::getClassName() const{
    return "SctData::DcsData";
  }

  DcsData::DcsData() 
    : m_vBias(0.), m_iBias(0.), m_t0(0.),  m_t1(0.), 
      m_vcc(0.), m_icc(0.), m_vdd(0.), m_idd(0.)   {}
  
  DcsData::~DcsData() {}

  float DcsData::getVbias() const {return m_vBias;}
  float DcsData::getIbias() const {return m_iBias;}
  float DcsData::getT0() const  {return m_t0;}
  float DcsData::getT1() const  {return m_t1;}
  float DcsData::getVcc() const  {return m_vcc;}
  float DcsData::getIcc() const  {return m_icc;}
  float DcsData::getVdd() const  {return m_vdd;}
  float DcsData::getIdd() const  {return m_idd;}

  void DcsData::setVbias(float val){m_vBias=val;}
  void DcsData::setIbias(float val){m_iBias=val;}
  void DcsData::setT0(float val){m_t0=val;}
  void DcsData::setT1(float val){m_t1=val;}
  void DcsData::setVcc(float val){m_vcc=val;}
  void DcsData::setIcc(float val){m_icc=val;}
  void DcsData::setVdd(float val){m_vdd=val;}
  void DcsData::setIdd(float val){m_idd=val;}

}
