package SctData;

import java.util.*;
import Sct.*;

/**
 * This class represents all the defects in a module.
 * It is essentially a map of channel number to a collection of ModuleDefect s.
 * @author Matthew Palmer
 */
public class ModuleDefectList implements Streamable {
    /** Create a new empty ModuleDefects object. */
    public ModuleDefectList() {
    }

    /** Add a defect. 
     * @throws IllegalArgumentException if defect is null or defect.isPrototype()     
     */
    public void addDefect(ModuleDefect defect) throws IllegalArgumentException {
        if (defect == null || defect.isPrototype()) throw new IllegalArgumentException("May not add prototypical ModuleDefects to a ModuleDefectList");
        defectList.add(defect);
    }

    /** Get all number of defects.*/
    public int size() {
        return defectList.size();
    }
    
    public ModuleDefect get(int i) {
        return (ModuleDefect)defectList.get(i);
    }

    /** Methods enquiring as to defects on ANY PART of a module element */
    public ModuleDefectList getDefectsAffectingElement(ModuleElement element) {
        ModuleDefectList l = new ModuleDefectList();
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.getModuleElement().overlaps(element)) l.addDefect(d);
        }
        return l;
    }

    public int getNDefectsAffectingElement(ModuleElement element) {
        int count = 0;
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.getModuleElement().overlaps(element)) ++count;
        }
        return count;
    }

    public boolean severeDefectAffectingElement(ModuleElement element) {
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.isSevere()) return true;
        }
        return false;
    }

    public boolean defectAffectingElement(ModuleElement element) {
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.getModuleElement().overlaps(element)) return true;
        }
        return false;
    }

    public boolean defectAffectingElement(ModuleElement element, ModuleDefect defect) {
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.isSameTypeAs(defect) && d.getModuleElement().overlaps(element)) return true;
        }
        return false;
    }

    public ModuleDefectList getDefectsEncompassingElement(ModuleElement element) {
        ModuleDefectList l = new ModuleDefectList();
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.getModuleElement().superset(element)) l.addDefect(d);
        }
        return l;
    }

    public int getNDefectsEncompassingElement(ModuleElement element) {
        int count = 0;
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.getModuleElement().superset(element)) ++count;
        }
        return count;        
    }

    public boolean severeDefectEncompassingElement(ModuleElement element) {
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.isSevere() && d.getModuleElement().superset(element)) return true;
        }
        return false;
    }

    public boolean defectEncompassingElement(ModuleElement element) {
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.getModuleElement().superset(element)) return true;
        }
        return false;
    }

    public boolean defectEncompassingElement(ModuleElement element, ModuleDefect defect) {
        for (int i=0; i<defectList.size(); ++i) {
            ModuleDefect d = get(i);
            if (d.isSameTypeAs(defect) && d.getModuleElement().superset(element)) return true;
        }
        return false;
    }

    public String getClassName() {
        return "SctData.ModuleDefectList";
    }
    
    public void add(ModuleDefectList param) {
        defectList.addAll(param.defectList);
    }
    
        
    public static ModuleDefectList read(IStream s, ObjectManager o) throws java.io.IOException {
        ModuleDefectList ml = new ModuleDefectList();
        int nDefects = s.readInt("NDefects");
        for (int i=0; i<nDefects; ++i) {
            ModuleDefect d = (ModuleDefect)o.readObject(s, "Defect", "SctData.ModuleDefect");
            ml.addDefect(d);
        }
        return ml;
    }
    
    public void write(OStream s, ObjectManager o) throws java.io.IOException {
        s.writeInt("NDefects", size(), false);
        for (int i=0; i<size(); ++i) {
            o.writeObject(s, "Defect", get(i), false);
        }
    }

    private ArrayList defectList = new ArrayList();
}
