package SctData;

import Sct.*;
import java.util.*;
import java.io.InputStream;
import java.lang.reflect.*;


/**
 * ConfigurationVariable represents a variable within ModuleConfiguration/ABCDModule.
 * Sub-classes represent the particular (logical) variables and the different ways of
 * setting them (e.g. ThresholdVariable represents the logical variable threshold and
 * mVThresholdVariable represents setting the threshold in mV, fCThresholdVariable represents setting it in fC).  The
 * sub-classes are intended to be singletons (as they are really strategies and flyweights).
 *
 * There are lots of methods here, but the basic concept is that there is some underlying 'actual'
 * value.  This is either the setting of the appropriate variable in ABCDModule.
 * For instance it could be a DAC setting.  The logical value is some manipulation of that - for instance
 * it could be the DAC setting in mV (rather than raw bits) or in fC is there is some calibration information
 * that allows one to be converted to another.
 *
 * This cocnept certainly has meaning for chip variables and may have meaning for others.  This class should be
 * refactored as and when this becomes apparent.
 *
 * The idea is that this should allow transparent and simple analysis of e.g. a thershold scan done in mV or fC.
 * For the moment these methods aren't used by anything, so I've commented them out 
 *
 *
 * @todo Refactor!!
 * @author Matthew Palmer
 */
public abstract class ConfigurationVariable implements Streamable {
        
    ConfigurationVariable(String variableName, String description) {
        this.repVal = ConfigurationVariableMap.getRep(getClass().getName());
        this.variableName = variableName;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigurationVariable) {
            return repVal == ((ConfigurationVariable)o).repVal;
        }
        return false;
    }

    public String getVariableName() {
        return variableName;
    }

    public String getStrategyDescription() {
        return description;
    }
    
    public String getClassName() {
        return "SctData.ConfigurationVariable";
    }
       
    /*
    public abstract double getLinkActualPoint(double logicalPt, ModuleConfiguration config, int link);

    public abstract double getChipActualPoint(double logicalPt, ModuleConfiguration config, int chip);

    public abstract double getChannelActualPoint(double logicalPt, ModuleConfiguration config, int channel);

    public abstract double getLinkLogicalPoint(double actualPt, ModuleConfiguration config, int link);

    public abstract double getChipLogicalPoint(double actualPt, ModuleConfiguration config, int chip);

    public abstract double getChannelLogicalPoint(double actualPt, ModuleConfiguration config, int channel);

    public abstract double getChipActualPoint(int config, ModuleConfiguration chip);

    public abstract void setChipActualPoint(double actualPt, ModuleConfiguration config, int chip);

    
    //Simple but inefficient implementations
    
    public double getChipLogicalPoint(int config, ModuleConfiguration chip) {        
    }

    public void setChipLogicalPoint(double logicalPt, ModuleConfiguration config, int chip) {
    }

    public double getModuleLogicalPoint(ModuleConfiguration config) {
    }

    public void setModuleLogicalPoint(double logicalPt, ModuleConfiguration config) {
    }
    */
    public static ConfigurationVariable read(IStream in, ObjectManager o) throws java.io.IOException {
        short rep = in.readShort("ScanVariable");
        try {
            return ConfigurationVariableMap.get(rep);            
        } catch (ClassNotFoundException e) {
            java.io.IOException ioe = new java.io.IOException();
            ioe.initCause(e);
            throw ioe;
        }        
    }
         
    public void write(OStream s, ObjectManager o) throws java.io.IOException {
        s.writeShort("ScanVariable", repVal, false);
    }
    
    private String variableName;
    private String description;    
    protected short repVal;
    
    
    private static class ConfigurationVariableMap {
        
        static ConfigurationVariable get(short rep) throws java.lang.ClassNotFoundException {
            String className = (String)map.hashMap1.get(new Short(rep));
            if (className == null) 
                return new DefaultVariable(rep);
            try {
                Class cfClass = ConfigurationVariableMap.class.getClassLoader().loadClass(className);
                return (ConfigurationVariable)cfClass.newInstance();            
            } catch (InstantiationException e) {
                return new DefaultVariable(rep);
            } catch (IllegalAccessException e) {
                return new DefaultVariable(rep);
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
                return new DefaultVariable(rep);
            } catch (Exception e) {
                e.printStackTrace();
                return new DefaultVariable(rep);
            }
        }
        
        static short getRep(String className) throws MissingResourceException {
            Short s = (Short)map.hashMap2.get(className);
            if (s==null) return 0;
            return s.shortValue();
        }
        
        /**
         * Initializes the map from the properties file: ConfigurationVariables.properties
         */        
        ConfigurationVariableMap() {            
            try {
                InputStream is = ConfigurationVariableMap.class.getClassLoader().getResourceAsStream("ConfigurationVariables.properties");
                if (is == null) throw new java.io.FileNotFoundException("ConfigurationVariableMap is uninitialized as properties file can't be found");                

                Properties p = new Properties();
                p.load(is);
                //Loop over all elements doing out thing

                Iterator it = p.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    Field f = Scans.class.getField((String)entry.getKey());
                    add((Short)f.get(null), (String)entry.getValue());
                }
            } catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error setting up ConfigurationVariableMap.  Likely problems with streaming");
            }
        }
         
        private void add(Short rep, String var) {
            if (!hashMap1.containsKey(rep)) {
                hashMap1.put(rep, var);
                hashMap2.put(var, rep);
            }
        }
        
        
        private static ConfigurationVariableMap map = new ConfigurationVariableMap();
        private HashMap hashMap1 = new HashMap();   ///< A map from Shorts to class names
        private HashMap hashMap2 = new HashMap();   ///< A map from class names to Shorts
    }

    
}
