#include "ScanResultWriter.h"
#include "dataTypes.h"

#include <CommonWithDsp/processor.h>
#include <CommonWithDsp/sctStructure.h>
#include <CommonWithDsp/ABCD/ABCDscans.h>

#include <cstdio>
#include <sstream>
#include <cstring>
#include <ctime>

using namespace std;
using namespace SctData;

//Prototypes
scan_result_ptrs* readFile(const char* name);
void help();
void publish(scan_result_ptrs& scanResult, unsigned int i);

//We assume we are given a list of files containing binary slice data
//Then we fake a header.
int main(int argc, char** argv) {
    if (argc != 3) help();

    bool multiThreaded = true;
    IPCCore::init(multiThreaded);	

    scan_result_ptrs* scanResult = readFile(argv[1]);
    if (!scanResult) {
	cout << "Failed to read in file: " << argv[1] << endl;
	return -1;
    }
    
    unsigned int publishCount = 0;
    string pCountStr(argv[2]);
    istringstream iss(pCountStr);
    iss >> publishCount;

    cout << "Going to publish file: " << argv[1] << " " << publishCount << " times" << endl;
    cout << "RunNumber: " << scanResult->header.runNumber << " Module: " << scanResult->header.moduleName << endl;
    cout << "ScanNumbers will start from 0" << endl;
    
    time_t start = time(0);
    time_t last10 = start;
    cout << "Start time: " << start << endl;
    
    for (unsigned int i=0; i<publishCount; ++i) {
	if (i%10 == 0 && i>0) {
	    time_t now = time(0);
	    cout << "Published scan: " << i-1 << endl;
	    cout << "Time now: " << now << " Time to do last 10: " << difftime(now, last10) << " seconds.  Average: " << difftime(now, last10)/10 << " s" << endl;
	    last10 = now;
	}
	if (i%100 == 0 && i>0) cout << endl;
	publish(*scanResult, i);
    }
    
    cout << endl << "Finished" << endl << endl;
    time_t now = time(0);
    cout << "Time now: " << now << " Total Time: " << difftime(now, start) << " seconds.  Average: " << flush << difftime(now, start)/publishCount << " s" << endl;    

    delete [] scanResult->points;
    delete [] scanResult->nEvents;
    delete [] scanResult->nErrorEvents;
    delete [] (short*)scanResult->data;

    return 0;
}

void help() {
    cout << "StressFilePublisher <FileName> <PublishCount>" << endl;
    cout << endl << "StessFilePublisher stress the IS/FittingService side of things by " << endl;
    cout << "publishing the raw data in the binary file <FileName> <PublishCount> times." << endl;
    exit(0);
}

void publish(scan_result_ptrs& scanResult, unsigned int i) {
    scanResult.header.scanNumber = i;
    ScanResultWriter::publish(scanResult);
}


//Handle the file
//Alogorithm is discover file size, allocate RAM
//Use the structs to fake the data then publish!
scan_result_ptrs* readFile(const char* name) {
    FILE * pFile;
    long lSize;

    pFile = fopen (name, "rb" );
    if (pFile==NULL)
        return 0;

    // obtain file size.
    fseek (pFile , 0 , SEEK_END);
    lSize = ftell (pFile);
    rewind (pFile);

    //New way of reading
    scan_result_ptrs&  scanResult = *new scan_result_ptrs();

    //read in header
    int n = fread(&scanResult.header, sizeof(ScanHeader), 1, pFile);

    //Read in scan points
    scanResult.points = new FLOAT32[scanResult.header.npoints];
    scanResult.nEvents = new UINT32[scanResult.header.npoints];
    scanResult.nErrorEvents = new UINT32[scanResult.header.npoints];

    fseek(pFile, scanResult.header.pntPoints, SEEK_SET);
    n = fread(scanResult.points, sizeof(FLOAT32), scanResult.header.npoints, pFile);

    fseek(pFile, scanResult.header.pntEvents, SEEK_SET);
    n = fread(scanResult.nEvents, sizeof(UINT32), scanResult.header.npoints, pFile);

    fseek(pFile, scanResult.header.pntErrors, SEEK_SET);
    n = fread(scanResult.nErrorEvents, sizeof(UINT32), scanResult.header.npoints, pFile);


    //Read in data
    scanResult.data = new short[scanResult.header.size];
    cout << scanResult.header.size << endl;
    fseek(pFile, scanResult.header.pntData, SEEK_SET);
    n = fread(scanResult.data, sizeof(UINT16), scanResult.header.size, pFile);

    //All done
    fclose (pFile);

    return &scanResult;
}
