#include "ScanResultWriter.h"
#include "ScanWriterFactory.h"
#include "ScanDataWriter.h"
#include "scan.h"
#include "Sct/SctNames.h"
#include "Sct/Serializable.h"
#include "Sct/ISProxy/IOManagerISProxy.h"
#include <CommonWithDsp/processor.h>

#include <sstream>

using namespace std;
using namespace Sct;
using namespace Sct::IS;
using namespace Sct::ISProxy;

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */

namespace SctData {

  /**
     Wraps pointers as a Serializable for IOManager.
   */

class SerializableWrapper : public virtual Serializable {    
public:
    SerializableWrapper(const string& className, const scan_result_ptrs& data) 
	: className(className) {
	ostringstream oss;
	oss << data.header.runNumber << "." << data.header.scanNumber << "." << data.header.moduleName;
	uniqueID = oss.str();
    }

    ~SerializableWrapper() throw() {}
    
    virtual string getClassName() const throw() {
	return className;
    }
    
    virtual string getUniqueID() const throw() {
	return uniqueID;
    }
    
private:
    string className;
    string uniqueID;
};

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */

unsigned ScanResultWriter::getVersion() const throw(){
  return m_version;
}

//No need to do anything
ScanResultWriter::ScanResultWriter(const string& className, unsigned version) 
    : scanResult(0), className(className), m_version(version) {}

ScanResultWriter& ScanResultWriter::getRawWriter() {
  static ScanResultWriter* rawWriter = new ScanResultWriter("SctData::RawScanResult", 2);
  return *rawWriter;
}

bool ScanResultWriter::rawInMap = IOManager::addToMap("SctData::RawScanResult", auto_ptr<Streamer>(&getRawWriter()));

/*ScanResultWriter& ScanResultWriter::getFitWriter() {
    static ScanResultWriter* fitWriter = new ScanResultWriter("FitScanResult");
    return *fitWriter;
}*/


bool ScanResultWriter::publish(scan_result_ptrs& scanResult) {
    //Now we can get hold of the ScanResultWriter we need
    ScanResultWriter& writer = ScanWriterFactory::getResultWriter(scanResult.header.dataType);
    writer.setData(scanResult);

    SerializableWrapper w(writer.className, scanResult);
    IOParamsIS params(SctNames::getEventDataName());
    IOManagerISProxy::instance().write(w, &params);

    return true;
}

void ScanResultWriter::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    writeHeader(out);
    writeScanPoints(out);
    writeConfiguration(out);
    writeData(out);
}
    
shared_ptr<Streamable> ScanResultWriter::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    return shared_ptr<Streamable>();
}

void ScanResultWriter::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
}



void ScanResultWriter::setData(scan_result_ptrs& scanResult) {
    this->scanResult = &scanResult;
}

void ScanResultWriter::writeHeader(OStream& out) const {
    writeClass("SctData::ResultHeader", out);
    ///@todo Version has been removed - is this wise
    //out << scanResult->header.version
    out << scanResult->header.runNumber << scanResult->header.scanNumber << scanResult->header.moduleName 
	<< scanResult->header.startTime << scanResult->header.endTime << scanResult->header.scanType;
}

void ScanResultWriter::writeScanPoints(OStream& out) const {
    writeClass("SctData::ScanPoints", out);
    //First the points header
    out << scanResult->header.npoints;
    //Now the points data
    out.put(scanResult->points, scanResult->header.npoints);
    out.put(scanResult->nEvents, scanResult->header.npoints);
    out.put(scanResult->nErrorEvents, scanResult->header.npoints);
}

void ScanResultWriter::writeConfiguration(OStream& out) const {
    writeClass("SctData::ModuleConfiguration", out);
    const ABCDModule& data = scanResult->header.config;

    for (unsigned int i=0; i<N_SCT_CHIPS; ++i) {
        writeChipConfig(out, data.chip[i]);
    }
    out << data.present << data.active << data.select << data.groupId << data.pTTC << data.rTTC;
    out.put(data.rx, 2);
    //cout << "data.groupId: " << (int)data.groupId  << endl;
}

void ScanResultWriter::writeChipConfig(OStream& out, const ABCDChip& data) const{
    out << data.active << data.address << data.target;
      
    //ABCDBasic stuff:
    
    //Config values
    out << data.basic.config.readoutMode << data.basic.config.calibMode << data.basic.config.trimRange;
    out << data.basic.config.edgeDetect << data.basic.config.mask << data.basic.config.accumulate;
    out << data.basic.config.inputBypass << data.basic.config.outputBypass << data.basic.config.master;
    out << data.basic.config.end << data.basic.config.feedThrough;
    
    out << data.basic.vthr << data.basic.vcal << data.basic.delay << data.basic.preamp << data.basic.shaper;
    out.put(data.basic.mask, 4);
    
    //ABCDCalData
    out << data.caldata.rc_function;
    //cout << "rc_function: " << (int)data.caldata.rc_function << endl;
    out.put(data.caldata.rc_params, 3);
    out << data.caldata.c_factor;
    
    out.put(data.trim, N_SCT_CHANS);
    //cout << "data.trim[35]" << (int)data.trim[35] << endl;
}


void ScanResultWriter::writeData(OStream& out) const {
    ScanDataWriter& writer = ScanWriterFactory::getDataWriter(scanResult->header.dataType);
    writer.writeData(*scanResult, out);
}


//Writes any stuff necessary for a class - ie nothing atm
void ScanResultWriter::writeClass(const string& name, OStream& out) {}
}
