#ifndef STREAMABLE_H
#define STREAMABLE_H

#include <string>

using std::string;

namespace Sct {

/**
Classes should implement this interface if they want to be serialized by the IO system.
For ease of implementation, all objects should be default constructible
@author Matthew Palmer	
*/
class Streamable {
public:
    /** Get the class name for this object.
    	This is used to identify the precise type.
    	@return the class name
	@note Nothrow
    */
    virtual string getClassName() const = 0;

    /**
      Virtual destructor to make it safe to delete through a pointer to a Streamable or any sub-class.
      @note Nothrow
    */
    virtual ~Streamable() {}
}
;

}

#endif //#ifndef STREAMABLE_H
