#ifndef SCT_IPCOBJECTEXCEPTION_H
#define SCT_IPCOBJECTEXCEPTION_H
#include "Exception.h"

namespace Sct {

/**
 * Thrown when an error publishing or withdrawing IPCObjects
 * @ingroup Exceptions
 * @author Matthew Palmer
 */
class IpcObjectException : public Exception {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    IpcObjectException(const string& msg, const string& file, int line) throw() {
	initialize("IPCOBJECT_ERROR", "Sct::IpcObjectException", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    IpcObjectException(Throwable& cause, const string& file, int line) throw() {
	initialize("IPCOBJECT_ERROR", "Sct::IpcObjectException", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    IpcObjectException(const string& msg, Throwable& cause, const string& file, int line) throw() {
	initialize("IPCOBJECT_ERROR", "Sct::IpcObjectException", msg, &cause, file, line);
    }
    
protected:
    IpcObjectException() throw() {} 
};

}

#endif //SCT_IPCOBJECTEXCEPTION_H
