#ifndef SCT_ISPROXY_ISPROXYSTREAMER_H
#define SCT_ISPROXY_ISPROXYSTREAMER_H

#include "../Streamer.h"
#include "../IoExceptions.h"
#include "../LogicErrors.h"

namespace Sct {
namespace ISProxy { 
    
class ISProxyStreamer : public virtual Streamer {    
public:
    //Streamer overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   

    virtual unsigned getVersion() const throw() {return s_version;}    
private:
    ISProxyStreamer() throw();
    static unsigned s_version;
    static bool inMap;
};
}
}
#endif //SCT_ISPROXY_ISPROXYSTREAMER_H
