/*
 * Scans.java
 *
 * Created on 17 September 2003, 15:21
 */

package Sct;

/**
 * A copy of all the constants in ABCD/ABCDscans.h
 * @author  Matthew Palmer
 */
public final class Scans {
    public static final short ELAPSED = 0;

    public static final short  VTHR = 1;
    public static final short  VCAL = 2;
    public static final short  STROBE_DELAY =3;
    public static final short  PREAMP =      4;
    public static final short  SHAPER =      5;

    public static final short  TRIM =        6;  /* set trim value of all channels */
    public static final short  MASK =        7;  /* predefined mask patterns used during testing */
    public static final short  ROLE =        8;
    public static final short  NMASK =       9;  /* number of channels to be masked */

    /*
     * ABCD3T Config Register Settings
     */
    public static final short  CAL_MODE =    10;  /* calibMode   */
    public static final short  COMPRESSION = 11;  /* readoutMode */
    public static final short  TRIM_RANGE  = 12;  /* trimRange   */
    public static final short  EDGE_DETECT = 13;  /* edgeDetect  */
    public static final short  SEND_MASK   = 14;  /* mask        */
    public static final short  ACCUMULATE  = 15;  /* accumulate  */

    public static final short  BYPASS      = 17;   /* predefined redundancy configurations
                                     to be used during production testing
                                     PWP 01.11.00 */
    public static final short  ACTIVE      = 18;  /* set ACTIVE or INACTIVE */

    public static final short  TOKEN       = 19;  /* a bit pattern that defines the bypass
                                                     scheme allowing all combinations. A '1'
                                                     means that the chip is read out, a '0'
                                                     means that the chip is bypassed/dead */

    /*
     * Adjustment of ABCD3T DAC settings using the calibration (RC) data
     */

    public static final short  QTHR        = 41;
    public static final short  QCAL        = 42;
    public static final short  TARGET      = 43;   /* Record of Trim Target PWP 06.12.02 */
    public static final short  TTHR        = 44;   /* Threshold in mV set wrt Trim Target PWP 06.12.02 */

}
