/*
 * ISProxy.java
 *
 * Created on 30 October 2003, 07:19
 */

package Sct.ISProxy;

import Sct.*;
import Sct.File.*;
/**
 *
 * @author  Matthew Palmer
 */
public class ISProxy implements Serializable {
    
    public ISProxy(String fileName) {
        setFileName(fileName);
    }
    
    /** Creates a new instance of ISProxy */
    public ISProxy(Serializable object) {
        filename = new NameFile(object).getName();
        uniqueID = object.getUniqueID();
        className = object.getClassName();
    }
    
    public String getClassName() {
        return className;        
    }
    
    public String getUniqueID() {
        return uniqueID;
    }
    
    public void write(OStream s, ObjectManager o) throws java.io.IOException {
        s.writeString("FileName", filename);
    }
    
    public static Serializable read(IStream s, ObjectManager o) throws java.io.IOException {
        String filename = s.readString("FileName");
        if (o instanceof ObjectManagerISProxy) {
            return new ISProxy(filename);
        } else {
            return ObjectManagerFile.getInstance().readObject(filename);
        }
    }
    
    public String getFileName() {
        return filename;
    }
    
    public void setFileName(String fileName) {        
        this.filename = fileName;
        NameFile nf = new NameFile(fileName);
        uniqueID = nf.getUniqueID();
        className = nf.getClassName();
    }
    
    private String filename;
    private String uniqueID;
    private String className;
}
