#include "Name_Test.h"
#include "../src/Archive/IONameArchiveFile.h"
#include "../src/SctNames.h"

#include <boost/test/unit_test.hpp>

using boost::unit_test_framework::test_suite;

namespace Sct {

  void testIONameArchFile1(){
    Archive::IONameArchiveFile name("ID","CLASSNAME");
    BOOST_CHECK_EQUAL(name.getUniqueID(), "ID");
    BOOST_CHECK_EQUAL(name.getClassName(), "CLASSNAME");
    string expected_name=SctNames::getPersistentDir();
    expected_name+="/CLASSNAME.ID.gz";
    BOOST_CHECK_EQUAL(name.getIOName(), expected_name);
  }
  void testIONameArchFile2(){
    Archive::IONameArchiveFile name("SctData::RawScanResult.551.44.20220330200020.gz");
    BOOST_CHECK_EQUAL(name.getUniqueID(), "551.44.20220330200020");
    BOOST_CHECK_EQUAL(name.getClassName(), "SctData::RawScanResult");
  }
      
  Name_Test::Name_Test() {
    add(BOOST_TEST_CASE(&testIONameArchFile1));
    add(BOOST_TEST_CASE(&testIONameArchFile2));
  }
}
