/*
 * DataCompare.java
 *
 * Created on 19 September 2003, 15:02
 */

package Sct.TestFramework;

import java.util.*;
import java.lang.reflect.*;

/**
 * This class compares two instances of the same type to see if all there data members are equal.
 * It decomposes each object and any references to other objects into primitives and compares these.
 * @author  Matthew Palmer
 */
public class DataCompare {
    public static boolean debug = false;
    
    public static DataCompareFailure lastFailure;
    
    /**
     * Returns true if o1 and o2 have identical fields
     */
    public static boolean compare(Object o1, Object o2) {
        return compare(o1, o2, new HashSet());
    }
    
    /**
     * Returns true if o1 and o2 have identical fields except for those
     * listed in ignore
     * @param ignore a Set of fully qualified field names to ignore for the comparison
     */
    public static boolean compare(Object o1, Object o2, Set ignore) {     
        if (debug) System.out.println("Compare: " + o1 + " and " + o2);
        //Check nulls
        if (o1 == null) {
            if (o2 == null) return true;
            else {
                lastFailure = new DataCompareFailure(o1, o2, null, "One object is null and the other aint");
                return false;
            }
        } else if (o2 == null) {
            lastFailure = new DataCompareFailure(o1, o2, null, "One object is null and the other aint");
            return false;
        }
        
        //Check classes
        if (!o1.getClass().equals(o2.getClass())) {
            lastFailure = new DataCompareFailure(o1, o2, null, "Objects are of different classes");
            return false;
        }
        
        //Check values
        if (o1.getClass().isArray()) {
            return compareArrays(o1, o2, new HashSet());
        } else {
            DataCompare d = new DataCompare(o1.getClass(), ignore);
            return d.compareRecurse(o1, o2);
        }
    }        
    
    protected DataCompare(Class c, Set ignore) {
        this.ignore = ignore;
        getAllFields(c);
    }
    
    /**
     * Setups a the lists of Fields objects that represent primitives and objects
     */
    protected void getAllFields(Class c) {
        if (debug) System.out.println("Getting All fields for " + c + "\n");  
        
        getFields(c);
        Class superClass = c;
        while (true) {
            superClass = superClass.getSuperclass();
            if (superClass == null) break;            
            getFields(superClass);            
        } 
        
        if (debug) {
            System.out.println("Got " + primitiveFields.size() + " primitive fields");
            System.out.println("Got " + objectFields.size() + " object fields");
            System.out.println("Got " + array.size() + " array fields");
            System.out.println("\n\n\n");
        }
    }
    
    protected void getFields(Class c) {
        if (debug) System.out.println("Get fields for " + c );
        Field[] fields = c.getDeclaredFields();        
        for (int i=0; i<fields.length; ++i) {
            //Ignore static fields
            if (Modifier.isStatic(fields[i].getModifiers())) continue;
            //Ignore fields in the ignore set:
            if (ignore.contains(fields[i])) continue;
            
            String name = fields[i].getName();
            int index = name.lastIndexOf('.');
            if (name.substring(index+1).startsWith("this$")) continue;

            if (debug) System.out.println("Got field: " + fields[i]);
            fields[i].setAccessible(true);
            Class type = fields[i].getType();
            
            if (type.isArray()) {
                array.add(fields[i]);                
            } else {
                if (type.isPrimitive()) primitiveFields.add(fields[i]);
                else objectFields.add(fields[i]);
            }
        }
    }
    
    /**
     * Compares the primitive fields of the two objects
     */
    protected boolean comparePrimitives(Object o1, Object o2) {
        for (int i=0; i<primitiveFields.size(); ++i) {
            try {
                Object ofield1 = ((Field)primitiveFields.get(i)).get(o1);
                Object ofield2 = ((Field)primitiveFields.get(i)).get(o2);
                if (!ofield1.equals(ofield2)) {
                    lastFailure = new DataCompareFailure(o1, o2, (Field)primitiveFields.get(i), "Primitives aren't equal " + ofield1 + " and " + ofield2);
                    return false;
                }
            } catch (IllegalAccessException iae) {
                System.out.println("Unable to access Field: " + primitiveFields.get(i));
                iae.printStackTrace();
            }   
        }
        return true;
    }
    
    protected boolean compareAllArrays(Object o1, Object o2) {
        for (int i=0; i<array.size(); ++i) {
            try {
                Object array1 = ((Field)array.get(i)).get(o1);
                Object array2 = ((Field)array.get(i)).get(o2);
                if (!compareArrays(array1, array2)) {
                    //Have to add object references and field
                    lastFailure.o1 = o1;
                    lastFailure.o2 = o2;
                    lastFailure.field = (Field)array.get(i);
                    return false;
                }
            } catch (IllegalAccessException iae) {
                System.out.println("Unable to access Field: " + array.get(i));
                iae.printStackTrace();
            }   
        }
        return true;        
    }
    
    /**
     * Compare 2 arrays
     */
    protected boolean compareArrays(Object array1, Object array2) {
        return compareArrays(array1, array2, ignore);
    }
    
    protected static boolean compareArrays(Object array1, Object array2, Set ignore) {
        if (array1 == null) {
            if (array2 == null) return true;
            else {
                lastFailure = new DataCompareFailure(null, null, null, "One array is null, the other aint");
                return false;
            }
        } else if (array2 == null) {
            lastFailure = new DataCompareFailure(null, null, null, "One array is null, the other aint");
            return false;
        }
        
        int length = Array.getLength(array1);
        boolean primitive = array1.getClass().getComponentType().isPrimitive();
        
        if (length != Array.getLength(array2)) {
            lastFailure = new DataCompareFailure(null, null, null, "Arrays different lengths: " + length + " and " + Array.getLength(array2));
            return false;
        }
        
        for (int i=0; i<length; ++i) {
            Object element1 = Array.get(array1, i);
            Object element2 = Array.get(array2, i);
            if (primitive) {
                if (!element1.equals(element2)) {
                    lastFailure = new DataCompareFailure(null, null, null, "Primitive element "+ i+ " not equal: " + element1 + " and " + element2);
                    return false;
                }
            } else {
                if (!compare(element1, element2, ignore)) {
                    DataCompareFailure temp = lastFailure;
                    lastFailure = new DataCompareFailure(null, null, null, "Object element "+ i+ " not equal: " + element1 + " and " + element2);
                    lastFailure.cause = temp;
                    return false;
                }
            }
        }
        return true;
    }
    
    /**
     * Recurse through the objectFields comparing them.
     */
    protected boolean compareRecurse(Object o1, Object o2) {
        if (!comparePrimitives(o1, o2)) {
            DataCompareFailure temp = lastFailure;
            lastFailure = new DataCompareFailure(o1, o2, null, "Primitives not equal");
            lastFailure.cause = temp;
            return false;
        }
        
        for (int i=0; i<objectFields.size(); ++i) {
            try {
                Object ofield1 = ((Field)objectFields.get(i)).get(o1);
                Object ofield2 = ((Field)objectFields.get(i)).get(o2);
                
                if (!compare(ofield1, ofield2, ignore)) {
                    DataCompareFailure temp = lastFailure;
                    lastFailure = new DataCompareFailure(o1, o2, (Field)objectFields.get(i), "Objects not equal");
                    lastFailure.cause = temp;                
                    return false;
                }
                
            } catch (IllegalAccessException iae) {
                System.out.println("Unable to access Field: " + objectFields.get(i));
                iae.printStackTrace();
            }   

        }
        if (!compareAllArrays(o1, o2)) {
            DataCompareFailure temp = lastFailure;
            lastFailure = new DataCompareFailure(o1, o2, null, "Arrays not equal");
            lastFailure.cause = temp;
            return false;
        }
        return true;
    }
    
    protected List primitiveFields = new ArrayList();
    protected List objectFields = new ArrayList();
    protected List array = new ArrayList(); 
    protected Set ignore;
}
