/************************************************************************************
 * comRegDfns.h:  Defines bits in the registers of the RRIF dual port register block
 *                and the master-slave communication mailbox (in each slave IDRAM).
 ************************************************************************************/
#ifndef COM_REG_DFNS
#define COM_REG_DFNS

#include "smSendTxtBuff.h"         /* pick up N_TXT_BUFFS */
#include "rodConfiguration.h"      /* pick up N_SLV_DSPS */

/* DSP Register Map from memoryPartitions.h
STATUS_REG_0     STATUS_REG_1     STATUS_REG_2     COMMAND_REG_0
DIAGNOSTIC_REG   TRAPSTAT_REG_0   TRAPSTAT_REG_1   LOOP_REG
HCMD_STAT_REG_0  HCMD_STAT_REG_1  HSTAT_REG_0      HSTAT_REG_1   
RESERVED_REG_0   RESERVED_REG_1   RESERVED_REG_2   RESERVED_REG_3  
RESERVED_REG_4   RESERVED_REG_5   RESERVED_REG_6   TASK_STATE_REG   
HCMD_REG         TRAP_CMD_STAT    INTR_DSP_HSHK    INTR_DSP_HSHK 
*/

/* STATUS_REG_0 */
#define SR_RUNNING                0
#define SR_BUSY                   (1 + (SR_RUNNING))
#define SR_EXECUTING              (1 + (SR_BUSY))
#define SR_PAUSED                 (1 + (SR_EXECUTING))

#define SR_OUT_LIST_RDY           (1 + (SR_PAUSED))
#define SR_DSP_ACK                (1 + (SR_OUT_LIST_RDY))
#define SR_DMA_ACCESS_ACK         (1 + (SR_DSP_ACK))
#define SR_DMA_ACCESS_ERR         (1 + (SR_DMA_ACCESS_ACK))

#define SR_TXT_BUFF_NE(x)         (1 + (x) + (SR_DMA_ACCESS_ERR))

/* the next available register bit is (1 + (N_TXT_BUFFS) + (SR_DSP_ACK)) */
#define SR_TXT_BUFF_PROC(x)       (1 + (x) + (SR_TXT_BUFF_NE(N_TXT_BUFFS-1)))

/* bit 16: */
#define SR_NTASKS                 (1 + (SR_TXT_BUFF_PROC(N_TXT_BUFFS-1)))
#define SR_NTASKS_W               3
#define SR_EVM                    (3 + (SR_NTASKS))          /* Slave DSPs */

#define SR_IDLS_ACTIVE            (1 + (SR_EVM))             
#define SR_IDLP_ACTIVE            (1 + (SR_IDLS_ACTIVE))     /* Master DSP */
#define SR_UNDEFINED1             (1 + (SR_IDLP_ACTIVE))
#define SR_UNDEFINED2             (2 + (SR_IDLP_ACTIVE))

#define SR_UNDEFINED3             (3 + (SR_IDLP_ACTIVE))
#define SR_UNDEFINED4             (4 + (SR_IDLP_ACTIVE))
#define SR_UNDEFINED5             (5 + (SR_IDLP_ACTIVE))
#define SR_UNDEFINED6             (6 + (SR_IDLP_ACTIVE))

#define SR_UNDEFINED7             (7 + (SR_IDLP_ACTIVE))
#define SR_UNDEFINED8             (8 + (SR_IDLP_ACTIVE))
#define SR_LOAD_ERROR             (1 + (SR_UNDEFINED8))      /* Master DSP */
#define SR_EMIF_ERROR             (1 + (SR_LOAD_ERROR))

/* STATUS_REG_1 */
#define SR_PRIM_LIST_INDEX      0
#define SR_PRIM_LIST_INDEX_W    4
#define SR_PRIM_INDEX          ((SR_PRIM_LIST_INDEX) + (SR_PRIM_LIST_INDEX_W))
#define SR_PRIM_INDEX_W        20

/* STATUS_REG_2 */
#define SR_SLVCOMM(x)             (x)
#define SR_HLTS(x)                (1 + (x) +(SR_SLVCOMM(N_SLV_DSPS-1)))
#define SR_SLVATTEND              (1 +(SR_HLTS(N_SLV_DSPS-1)))

/* COMMAND_REG_0 */
#define CR_IN_LIST_RDY            0
#define CR_PAUSE                  (1 + (CR_IN_LIST_RDY))
#define CR_RESUME                 (1 + (CR_PAUSE))
#define CR_ABORT                  (1 + (CR_RESUME))
#define CR_TXT_BUFF_RR(x)         (1 + (x) + (CR_ABORT))
/* the next available register bit is (1 + (N_TXT_BUFFS) + (CR_ABORT))  */
#define CR_ID                     (1 + CR_TXT_BUFF_RR(N_TXT_BUFFS-1))
#define CR_ID_W                   2   /* IDs for slave DSPs- on master, unused. */
#define CR_DMA_ACCESS_REQ         ((CR_ID_W) + (CR_ID))
#define CR_FLUSH_EVENTS           (1 + (CR_DMA_ACCESS_REQ))   /* Slave DSPs */
#define CR_IDLP_ACTIVE            (1 + (CR_FLUSH_EVENTS))     /* Slave DSPs */
#define CR_HISTO_OVERRIDE         (1 + (CR_IDLP_ACTIVE))      /* Slave DSPs */

/* Diagnostic Register */
#define DR_DISP_ROD_REG_ID       0
#define DR_LOOPEVENT             0  //SDSP
#define DR_DISP_SERIAL_LOOPS     1
#define DR_HISTO_1               2  //SDSP
#define DR_USE_ROD_MASK_LUT      2  //MDSP
#define DR_HISTO_3               3
#define DR_DISP_MIRROR_CTIME     4
//#define DR_HCTRL_CAPTURE_SET     5
#define DR_STEP_CTRL             6
#define DR_STEP_TRIGGER          7
//#define DR_DELAY                 8
#define DR_SOFT_BC_RESET         9
//#define DR_MUTE                  10
//#define DR_ARDY                  11
#define DR_MAINLOOP_TOGGLE       12

#define DR_PULSE_PAUSE           14
#define DR_TIMING_DISPLAY        15
#define DR_INFO_DISPLAY          16
//#define DR_DMA_ACK               17
#define DR_MODULE_CFG_LOOP       17
#define DR_SLAVE_WRITE_TEST      18
#define DR_CACHE_FLUSH           17 //SDSP
#define DR_CACHE_RANGE_FLUSH     18 //SDSP
#define DR_CACHE_TOGGLE          19 //SDSP

#define DR_ISR_DELAY             19
#define DR_DISP_LINK_DATA        20
#define DR_AUTO_STALL            21
#define DR_STAGE_PAUSE           22
//#define DR_REPORTS               23
#define DR_BIN_PAUSE             24
//#define DR_DELAY_DEBUG           25
#define DR_NEW_FMTR              26
#define DR_DYN_DBG               27
//#define DR_PAUSE_STAGE           30
#define DR_RESET_FIFOS           31

/* Histogram Command & Status Registers */
#if (defined(I_AM_MASTER_DSP) || defined(I_AM_NT_HOST) || defined(I_AM_LINUX_HOST))
	#define HCSR0_BIN          0
	#define HCSR0_BIN_W        8
	#define HCSR0_CHIP         8
	#define HCSR0_CHIP_W       8
	#define HCSR0_STAGE        16
	#define HCSR0_STAGE_W      16

	//#define HCSR0_CALLINE      8
	//#define HCSR0_CALLINE_W    5
	//#define HCSR0_CALLINE_EN   15
	//#define HCSR0_ERRORCNT     16
	//#define HCSR0_ERRORCNT_W   16

	#define HCSR1_AVGTRANS     0
	#define HCSR1_AVGTRANS_W   8
	#define HCSR1_AVGLEN       8
	#define HCSR1_AVGLEN_W     8
	#define HCSR1_AVGPROC      16
	#define HCSR1_AVGPROC_W    16

	#define HSR_SLV_W        16
	#define HSR0_SLV3        16
	#define HSR0_SLV2        0
	#define HSR1_SLV1        16
	#define HSR1_SLV0        0
#endif

/* Definitions of the slave's command and status registers are different; 
   master must know both. */
#define HCSR0_SLV_BIN          0
#define HCSR0_SLV_BIN_W        8
#define HCSR0_SLV_CALLINE      8
#define HCSR0_SLV_CALLINE_W    5
#define HCSR0_SLV_CALLINE_EN   15
#define HCSR0_SLV_NEWBIN       16
#define HCSR0_SLV_NEWCAL       17

#define HCSR1_SLV_BINEVT       0
#define HCSR1_SLV_BINEVT_W     32

#define HSR0_SLV_RDY          0
#define HSR0_SLV_EXP          1
#define HSR0_SLV_PROC         2
#define HSR0_SLV_DONE         3
#define HSR0_SLV_BINERR       8
#define HSR0_SLV_BINERR_W     8
#define HSR0_SLV_PROCTIME     16
#define HSR0_SLV_PROCTIME_W   16

#define HSR1_SLV_EVTS_REC     0
#define HSR1_SLV_EVTS_REC_W   32

/* Trap command-status register */
#define TCSR_TRAILER           0
#define TCSR_TRANSMIT          1
#define TCSR_HEADER            2
#define TCSR_ISR_ACTIVE        3

#define TCSR_DATA_ERROR        4
#define TCSR_HEADER_ERROR      5
#define TCSR_TRAILER_ERROR     6
#define TCSR_LINK_ERROR        7

#define TCSR_ERROR             8
#define TCSR_ISR_PENDING      11

#define TCSR_OVERFLOW_ERROR   14
#define TCSR_OVERFLOW         15

#define TCSR_ERR_COUNT        16
#define TCSR_ERR_COUNT_W       8

#define TCSR_EVT_COUNT        24
#define TCSR_EVT_COUNT_W       8

/* Trap status register 0 */
#define TSR0_EVT_WORD_CNT        0
#define TSR0_EVT_WORD_CNT_W     16

#define TSR0_IFRAME_TAIL        16
#define TSR0_IFRAME_TAIL_W      8
#define TSR0_XFRAME_TAIL        24
#define TSR0_XFRAME_TAIL_W      8

/* Trap status register 1 */
#define TSR1_IFRAME_HEAD        16
#define TSR1_IFRAME_HEAD_W      8
#define TSR1_XFRAME_HEAD        24
#define TSR1_XFRAME_HEAD_W      8



/* The loop register (increments once per loop */
#define LR_CNT                0
#define LR_CNT_W             32


/* INTR_DSP_HSHK_WR and INTR_DSP_HSHK_RD */
/* The following bits are defined in each of these registers.  They are used for the
 * handshake between the master and a slave when either sends a list to the other.
 * The state machine is simpler than for host-originated lists, e.g. there is no
 * option to pause. */
 
#define INTR_DSP_IN_LIST_RDY    (0)
#define INTR_DSP_ABORT          ((INTR_DSP_IN_LIST_RDY) + 1)
#define INTR_DSP_ACK            ((INTR_DSP_ABORT) + 1)
#define INTR_DSP_OUT_LIST_RDY   ((INTR_DSP_ACK) + 1)

#endif

