/*
 * SearchableObjectRegistry.java
 *
 * Created on 28 November 2002, 23:14
 */

package GuiComponents.scripting;

import org.apache.bsf.util.*;
import java.util.*;
import java.lang.reflect.*;

/**
 *
 * @author  palmer
 */
public class SearchableObjectRegistry extends ObjectRegistry implements NameCompleter {
    
    /** Creates a new instance of SearchableObjectRegistry */
    public SearchableObjectRegistry() {
    }

    /**
     * Following code copied(!) from super class - I need access to data members arrgghh!
     */
    Hashtable      reg    = new Hashtable ();
    SearchableObjectRegistry parent = null;

    public SearchableObjectRegistry (SearchableObjectRegistry parent) {
        this.parent = parent;
    }

    // register an object
    public void register(String name, Object obj) {
        reg.put(name, obj);       
    }
    
    // unregister an object (silent if unknown name)
    public void unregister(String name) {
        reg.remove(name);      
    }
    
    // lookup an object: cascade up if needed
    public Object lookup(String name) throws IllegalArgumentException {
        Object obj = reg.get(name);
        
        if (obj == null && parent != null) {
            obj = parent.lookup(name);
        }
        
        if (obj == null) {
            throw new IllegalArgumentException("object '" + name + "' not in registry");
        }
        
        return obj;
    }
   
    
     /**
     * Tries to complete this string!!
     * Strategy: 
     *      attempt only to do this for objects and variables
     *      i.e. do not try and find package names/classes
     *      so, require everything before a dot to be the beginning of a variable name
     *      (if there is a . then it is a variable name)
     *      everything after the dot is a field/method or constructor name
     *      Use reflection to find these out
     * The string should be in Java format - i.e. dots separate fields
     * other languages may need to translate to get into this format
     */
    public List completeName(String context, String part) {
        int index = part.indexOf('.');
        if (index == -1) {
            return completeVarName(part);
        } else {
            String expr = part.substring(0, index + 1);
            String varname = part.substring(0, index);
            String prefix = part.substring(index+1);
            
            try {
                Object var = lookup(varname);
                return completeMemberName(var, expr, prefix);
            } catch (IllegalArgumentException e) {
                return new Vector(0);
            }
        }
    }
    
    /**
     * Completes a name that is definately a var name (or nothing!)
     */
    protected List completeVarName(String str) {
        //Complete strings in this Registry
        Vector v = new Vector();
        Enumeration e = reg.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.startsWith(str))
                v.add(s);
        }        
        
        if (parent != null) v.addAll(parent.completeVarName(str));
        return v;
    }
    
    /**
     * Completes a member name
     * @param var The object
     * @param prefix The part to be completed
     */
    protected List completeMemberName(Object var, String expr, String prefix) {
        Class c = var.getClass();
        
        //If there is a dot in the prefix, then things get tricky
        if (prefix.indexOf('.') != -1) {
            int index = prefix.lastIndexOf('.');
            String str = prefix.substring(0, index);
            prefix = prefix.substring(index+1);
	    expr += str + ".";
            c = parseString(c, str);
        }
        
        if (c==null) return new Vector(0);
        
        Vector v = new Vector();              
        
        //Methods
        Method[] ms = c.getMethods();
        for (int i=0; i<ms.length; i++) {
            if (ms[i].getName().startsWith(prefix)) v.add(expr + ms[i].getName()+'(');            
        }
        
        //Fields
        Field[] fs = c.getDeclaredFields();
        for (int i=0; i<fs.length; i++) {
            if (fs[i].getName().startsWith(prefix)) v.add(expr + fs[i].getName());
        }
        
        return v;
    }
    
    /**
     * Returns the class associated with the result of str applied to c
     * Note, don't actually do it!!
     */
    protected Class parseString(Class c, String str) {
        //Recurse if there are more dots
        if (str.indexOf('.') != -1) {
            int index = str.lastIndexOf('.');
            String prefix = str.substring(0,index);
            str = str.substring(index+1);
            c = parseString(c, prefix);
        }
        
        //Is it a field or method?
        if (str.indexOf('(') == -1) {
            try {
                Field f = c.getDeclaredField(str);
                return f.getType();
            } catch (Exception e) {
                return null;
            }
        } else {
            str = str.substring(0, str.indexOf('('));            
            Method[] ms = c.getMethods();
            for (int i=0; i<ms.length; i++) {
                if (ms[i].getName().equals(str)) return ms[i].getReturnType();
            }
            // We don't try anything fancy here - we get all methods and use the one that works
        }
        return null;
    }
    
    public List provideHelp(String method) {
        return new Vector(0);
    }
    
}
