/*
 * ScriptingInterface.java
 *
 * Created on 09 December 2003, 18:40
 */

package GuiComponents.scripting;

import org.apache.bsf.*;
import java.lang.ref.*;
import GuiComponents.Console.*;
import GuiComponents.System.*;

/**
 * This is the entry point for external programs wanting to use scripting
 * @author  Matthew Palmer
 */
public class ScriptingInterface {
    
    public static ScriptingInterface instance() {
        if (instance == null) instance = new ScriptingInterface();
        return instance;
    }
    
    /**
     * Use this to get access to the manager - in particular for adding extra variables
     */
    public BSFManager getManager() {
        return manager;
    }
    
    public Interpreter getBeanShellInterpreter() {
        return createInterpreter(new BeanShellFactory());
    }
    
    public Interpreter getJythonInterpreter() {
        return createInterpreter(new JythonFactory());
    }
    
    /*    public Interpreter getJavaScriptInterpreter() {
        return createInterpreter(new JavaScriptFactory());
        }*/
    
    
    private Interpreter createInterpreter(ScriptFactory sf) {
	///@todo Should we throw an exception here?
	if (currentInterpreter.get() != null) {
	    Interpreter i = (Interpreter)currentInterpreter.get();
	    //System.out.println(" Interpreter: " + i + " Console: " + i.getConsole());
	    return null;
	}
	
	Interpreter i = sf.createInterpreter(manager);
	//currentInterpreter = new WeakReference(i);
        JConsole console = i.getConsole();
        console.println("SctRodDaq scripting");
        console.println("The most useful object is \"SI\" which is an interface to the rest of the system.");
        console.println("There may also be rudimentary tab completion");
        console.println("Finally, you may load and execute from a file by typing \".x <filename>\"");
        
        return i;
    }
    
    /** Creates a new instance of ScriptingInterface */
    private ScriptingInterface() {
        manager = new BSFManager();
        registry = new SearchableObjectRegistry();
        manager.setObjectRegistry(registry);
        
        try {
            manager.declareBean("SI", SystemInterface.getInstance(), SystemInterface.class);            
        } catch (BSFException be) {
            System.err.println("Error initializing manager: " + be);
        }
    }
    
    private static ScriptingInterface instance = null;
    private BSFManager manager;
    private SearchableObjectRegistry registry;
    private WeakReference currentInterpreter = new WeakReference(null);
}
