/*
 * PrimitiveDiagnostics.java
 *
 * Created on 14 January 2004, 11:57
 */

package GuiComponents.SctApi;

/**
 * Panel for ROD diagnostics using Primitive Lists
 *
 * @author  gallop
 */
public class PrimitiveDiagnostics extends javax.swing.JPanel {
    int partition;
    int crate;
    int rod;
    Sct_SctApi.SctApi api;
    
    /** Creates new form PrimitiveDiagnostics */
    public PrimitiveDiagnostics() {
        initComponents();
        myInitComponents();
    }

    /** Creates new form RodDiagnostics */
    public PrimitiveDiagnostics(int p, int c, int r, Sct_SctApi.SctApi a) {
        partition = p;
        crate = c;
        rod = r;
        api = a;

        initComponents();
        myInitComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel2 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        echoText = new javax.swing.JTextField();
        jButton5 = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jTextField4 = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        jButton1.setText("Close");
        jPanel2.add(jButton1);

        add(jPanel2, java.awt.BorderLayout.SOUTH);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

        jLabel11.setText("Text");
        jPanel1.add(jLabel11);

        echoText.setText("The quick brown fox jumped over the lazy dog");
        jPanel1.add(echoText);

        jPanel3.add(jPanel1);

        jButton5.setText("Send Echo Primitive");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendEchoPerformed(evt);
            }
        });

        jPanel3.add(jButton5);

        add(jPanel3, java.awt.BorderLayout.CENTER);

        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.X_AXIS));

        jLabel3.setText("Partition");
        jPanel4.add(jLabel3);

        jTextField2.setEditable(false);
        jTextField2.setText(new Integer(getPartition()).toString());
        jPanel4.add(jTextField2);

        jLabel4.setText("Crate");
        jPanel4.add(jLabel4);

        jTextField3.setEditable(false);
        jTextField3.setText(new Integer(getCrate()).toString());
        jPanel4.add(jTextField3);

        jLabel5.setText("ROD");
        jPanel4.add(jLabel5);

        jTextField4.setEditable(false);
        jTextField4.setText(new Integer(getROD()).toString());
        jPanel4.add(jTextField4);

        add(jPanel4, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private void sendEchoPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendEchoPerformed
        byte [] text = echoText.getText().getBytes();
        int [] block = new int[text.length / 4];
        
        for(int i=0; i<block.length; i++) {
            block[i] = text[i*4+0];
            block[i] += text[i*4+1] << 8;
            block[i] += text[i*4+2] << 16;
            block[i] += text[i*4+3] << 24;
        }

        try {
            api.echo(getPartition(), getCrate(), getROD(), block);
        } catch(Sct_SctApi.SctApiException s) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed echo: " + s.detail);
        }
    }//GEN-LAST:event_sendEchoPerformed

    void myInitComponents() {
    }    
    
    public int getPartition() {
        return partition;
    }

    public int getCrate() {
        return crate;
    }

    public int getROD() {
        return rod;
    }

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField echoText;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton5;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField4;
    // End of variables declaration//GEN-END:variables
    
}
