package GuiComponents.SctApi;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.table.TableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.JTableHeader;

public class AutoConfigure extends JPanel {
    Sct_SctApi.SctApi api;

    ResultsTableModel tableModel;
    
    Sct_SctApi.AutoConfigResult[] autoResults;

    int suggestedRx[];

    public AutoConfigure(Sct_SctApi.SctApi a) {
        api = a;

        tableModel = new AutoConfigure.ResultsTableModel();
        autoResults = null;
        
        initComponents();
        modifyComponents();
    }

    // For beanability
    public AutoConfigure() {
        initComponents();
        autoResults = null;
        modifyComponents();
    }

    public void modifyComponents() {
//         updateResultsPanel();

        int columnWidth = jTable1.getFontMetrics(jTable1.getFont()).stringWidth("mmmmmm");

        // Enough to see "link 48"
        TableColumn column = jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(columnWidth * 8);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        jButton4 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setOpaque(false);
        jButton4.setText("Close");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonPerformed(evt);
            }
        });

        jPanel1.add(jButton4);

        add(jPanel1, java.awt.BorderLayout.SOUTH);

        jPanel3.setLayout(new java.awt.BorderLayout());

        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.X_AXIS));

        jButton2.setText("Perform scan");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                performScanActionPerformed(evt);
            }
        });

        jPanel4.add(jButton2);

        jButton3.setText("Enact configuration changes");
        jPanel4.add(jButton3);

        jPanel3.add(jPanel4, java.awt.BorderLayout.NORTH);

        jTable1.setFont(new java.awt.Font("Monospaced", 0, 12));
        jTable1.setModel(getScanResultsTableModel());
        jScrollPane1.setViewportView(jTable1);

        jPanel3.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(jPanel3, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void performScanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_performScanActionPerformed
        // Perform Scan
        try {
            autoResults = api.autoConfigureScan();

            updateScanResults();
        } catch(Sct_SctApi.SctApiException e) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed autoConfigureScan: " + e);
        }
    }//GEN-LAST:event_performScanActionPerformed

    private void closeButtonPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonPerformed
        ((Window)getTopLevelAncestor()).dispose();
    }//GEN-LAST:event_closeButtonPerformed

    TableModel getScanResultsTableModel() {
        return tableModel;
    }
    
    void updateScanResults() {
        tableModel.newData();

        suggestedRx = new int[autoResults.length];

        // Fix select and tx swapping?
        for(int i=0; i<autoResults.length; i++) {
            suggestedRx[i] = autoResults[i].rx;
        }
    }

    void enactConfigurationChanges() {
        sctConf.Configuration conf = GuiComponents.System.SystemInterface.getInstance().getConfigurationService();

        for(int i=0; i<autoResults.length; i++) {
            try {
                conf.setFibreMapping(autoResults[i].partition, autoResults[i].crate, autoResults[i].rod, 
                                     autoResults[i].tx, autoResults[i].tx, suggestedRx[i] * 2, suggestedRx[i] * 2 + 1);
            } catch(sctConf.ConfigurationException e) {
                JOptionPane.showMessageDialog(null, "Failed to set mapping for scan member " + i + ": " + e);
            }
        }

        JOptionPane.showMessageDialog(null, "The mappings have been set as shown.\n" 
                                      + " This automated procedure may be confused by settings of the select line from DCS\n"
                                      + " or by incorrectly ordered fibres within a bundle");
    }

    class ResultsTableModel extends javax.swing.table.AbstractTableModel {
        public ResultsTableModel() {
        }

        public void newData() {
            fireTableStructureChanged();
        }
        
        public int getColumnCount() {
            return 6;
        }

        public int getRowCount() {
            if(autoResults == null) return 0;
            return autoResults.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if(columnIndex == 0) {
                return "" + autoResults[rowIndex].partition;
            } else if(columnIndex == 1) {
                return "" + autoResults[rowIndex].crate;
            } else if(columnIndex == 2) {
                return "" + autoResults[rowIndex].rod;
            } else if(columnIndex == 3) {
                return "" + autoResults[rowIndex].tx;
            } else if(columnIndex == 4) {
                return "" + autoResults[rowIndex].rx;
            } else if(columnIndex == 5) {
                return "" + suggestedRx[rowIndex];
            } else {
                return "Unexpected request";
            }
        }

        public String getColumnName(int columnIndex) {
            String retValue;
            
            if(columnIndex == 0) {
                retValue = "Partition";
            } else if(columnIndex == 1) {
                retValue = "Crate";
            } else if(columnIndex == 2) {
                retValue = "ROD";
            } else if(columnIndex == 3) {
                retValue = "Tx channel";
            } else if(columnIndex == 4) {
                retValue = "Rx channel";
            } else if(columnIndex == 5) {
                retValue = "Rx suggested";
            } else {
                columnIndex--;
                retValue = "Column " + columnIndex;
            }

            return retValue;
        }
    }    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables
}
