#include "FitAlgorithmMap.h"
#include "FitAlgorithm.h"
#include "SctData/ConfigurationVariable.h"

#include <iostream>
using namespace std;

namespace SctFitter {

FitAlgorithmMap& FitAlgorithmMap::instance() {
    static FitAlgorithmMap* map = new FitAlgorithmMap();
    return *map;
}
    
const FitAlgorithm& FitAlgorithmMap::getAlgorithm(const ConfigurationVariable& variable) const throw(Sct::InvalidArgument) {
    if (algMap.count(variable.getVariableName()) == 0) {
	Sct::InvalidArgumentError iae("No map for ConfigurationVariable: " + variable.getVariableName(), __FILE__, __LINE__ );
	iae.setSeverity(MRS_DIAGNOSTIC);
	throw iae;
    }
    return *(*algMap.find(variable.getVariableName())).second;
}
    
bool FitAlgorithmMap::setAlgorithm(string variableName, auto_ptr<FitAlgorithm> alg) throw() {
    algMap[variableName] = shared_ptr<FitAlgorithm>(alg);
    return true;
}
    
}
