#ifndef TOKENSCAN_H
#define TOKENSCAN_H

#include "../ipc/Sct_CalibrationController.hh"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>

using namespace Sct;
using SctCalibrationController::Ipc::ScanRequest;
namespace SctCalibrationController {
namespace Scripts {
    
class TokenScan : public ScanRequestImpl {
public:
    static ScanRequestImpl& tokenScan() {
        static TokenScan request;
	Sct_SctApi_T_SctApi* api = CalibrationControllerImpl::instance().getApi();
        Sct_SctApi_T_Scan* s = 0;
        APIRETCALL(api, s, createScan(&st), "Failed to create scan")
        request.setScan(s);

        APICALL(s, setNTrigs(&st, 100), "Failed to set triggers")

        Sct_SctApi_T_Trigger* t = 0;
        APIRETCALL(s, t, getTrigger1(&st), "Failed to get Trigger1")

        APICALL(t, singleL1A(&st), "Failed to set trigger type")

        APICALL(s, configure(&st, ST_TOKEN, 0, 35, 1), "Failed to set Scan information")

        return request;
    }
    
private:
    TokenScan(){;}
};
    
}
}

#endif //TOKENSCAN_H
