#ifndef SCTCALIBRATIONCONTROLLER_RXTHRESHOLDTEST_H
#define SCTCALIBRATIONCONTROLLER_RXTHRESHOLDTEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"

#include "../SctApiAccessException.h"
#include "../SctApiCall.h"
#include "../CalibrationControllerImpl.h"
#include "Sct/LogicErrors.h"
#include "SctApi/extraScans.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {
    
class RxThresholdTest : public TestRequestImpl {
public:	
    static RxThresholdTest& instance() {
	static RxThresholdTest rc;
	return rc;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& the_api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &the_api;
        // No masked channels
	name = "RxThresholdTest";
	testVariable = ST_ELAPSED;
	nScans = 1;
	// put in clock / 2 mode.
	APICALL(api, modifyABCDVar(&st, ST_FEEDTHROUGH, 0), "RxThresholdTest::startTest");
	testPoints.push_back(nTriggers);
    }
    
    virtual ScanRequest* getNextScan(unsigned long index) {
	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
	ScanRequest& request = sl.rawScan(nTriggers);
	Sct_SctApi_T_Scan* scan = request.getScan();
	
	APICALL(scan, configure(&st, ST_RX_THRESHOLD, 0, 255, 5), "Failed to set Scan information")
        return &request;
    }
    
    virtual bool canFeedback() {
	return true;
    }
    
    virtual void endTest() {
      // put back in not clock/2 mode
        APICALL(api, modifyABCDVar(&st, ST_FEEDTHROUGH, 1), "RxThresholdTest::startTest");
	api = 0;
    }

private:
    RxThresholdTest() {}
    Sct_SctApi_T_SctApi* api;    
    static const int nTriggers = 10;
};
}
}
#endif //SCTCALIBRATIONCONTROLLER_RXTHRESHOLDTEST_H
