#ifndef NOISEOCCUPANCY_H
#define NOISEOCCUPANCY_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"
#include "../SctApiCall.h"

#include "NoiseOccupancyScan.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {
    
class NoiseOccupancyTest : public TestRequestImpl {
public:	
    static NoiseOccupancyTest& instance() {
	static NoiseOccupancyTest no;
	return no;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &api;

        // Compression mode X1X
        APICALL(&api, modifyABCDVar(&st, ST_COMPRESSION, 1), "NoiseOccupancyTest::startTest")

        // Edge detect off
        APICALL(&api, modifyABCDVar(&st, ST_EDGE_DETECT, 0), "NoiseOccupancyTest::startTest")

        // No masked channels
        APICALL(&api, modifyABCDVar(&st, ST_SEND_MASK, 0), "NoiseOccupancyTest::startTest")

	name = "NoiseOccupancyTest";
	testVariable = ST_ELAPSED;
	nScans = 1;
	testPoints.push_back(0.);
    }
    
    virtual ScanRequest* getNextScan(unsigned long index) {
	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
        
        APICALL(api, modifyABCDVar(&st, ST_QCAL, 0.), "NoiseOccupancyTest::getNextScan")

	return &sl.noiseOccupancyScan();
    }
    
    virtual bool canFeedback() {
	return false;
    }
    
    virtual void endTest() {
	api = 0;
    }
    
    
private:
    NoiseOccupancyTest() {}
    Sct_SctApi_T_SctApi* api;    
};
}
}
#endif //RESPONSECURVE_H
