#ifndef SCTCALIBRATIONCONTROLLER_NMASKTEST_H
#define SCTCALIBRATIONCONTROLLER_NMASKTEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"

#include "../SctApiAccessException.h"
#include "../SctApiCall.h"
#include "../CalibrationControllerImpl.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {
    
class NMaskTest : public TestRequestImpl {
public:	
    static NMaskTest& instance() {
	static NMaskTest rc;
	return rc;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &api;

        // Compression mode X1X
        APICALL(&api, modifyABCDVar(&st, ST_COMPRESSION, 1), "NMaskTest::startTest")

        // Edge detect off
        APICALL(&api, modifyABCDVar(&st, ST_EDGE_DETECT, 0), "NMaskTest::startTest")

        // No masked channels
        APICALL(&api, modifyABCDVar(&st, ST_SEND_MASK, 1), "NMaskTestassTest::startTest")

	name = "NMaskTest";
	testVariable = ST_ELAPSED;
	nScans = 1;
	
	testPoints.push_back(nTriggers);
    }
    
    virtual ScanRequest* getNextScan(unsigned long index) {
	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
	return &sl.nmaskScan(nTriggers);
    }
    
    virtual bool canFeedback() {
	return false;
    }
    
    virtual void endTest() {
	api = 0;
    }
    
private:
    NMaskTest() {}
    Sct_SctApi_T_SctApi* api;    
    static const int nTriggers = 100;
};
}
}
#endif //SCTCALIBRATIONCONTROLLER_NMASKTEST_H
