#include "ScanLibrary.h"
#include "ScanRequest.h"
#include "CalibrationController.h"

namespace SctCalibrationController {
namespace Ipc {
    
ScanLibrary::ScanLibrary() : IPCCallback(&CalibrationController::getServer()) {
}

Sct_CalibrationController_T_ScanRequest * ScanLibrary::thresholdScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs) {
  ScanRequestImpl& req = thresholdScan(nTrigs);
  req.incRef();
  return &req;
}

Sct_CalibrationController_T_ScanRequest * ScanLibrary::rawScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs) {
  ScanRequestImpl& req = rawScan(nTrigs);
  req.incRef();
  return &req;
}

Sct_CalibrationController_T_ScanRequest * ScanLibrary::thresholdScanfC (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs, ilu_Real calCharge) {
  ScanRequestImpl& req = thresholdScanfC(nTrigs, calCharge);
  req.incRef();
  return &req;
}

Sct_CalibrationController_T_ScanRequest * ScanLibrary::noiseOccupancyScan (Sct_CalibrationControllerStatus *_status) {
  ScanRequestImpl& req = noiseOccupancyScan();
  req.incRef();
  return &req;
}

Sct_CalibrationController_T_ScanRequest * ScanLibrary::strobeDelayScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs) {
  ScanRequestImpl& req = strobeDelayScan(nTrigs);
  req.incRef();
  return &req;
}
    
Sct_CalibrationController_T_ScanRequest * ScanLibrary::nmaskScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs) {
  ScanRequestImpl& req = nmaskScan(nTrigs);
  req.incRef();
  return &req;
}
   
Sct_CalibrationController_T_ScanRequest * ScanLibrary::tokenScan (Sct_CalibrationControllerStatus *_status) {
  ScanRequestImpl& req = tokenScan();
  req.incRef();
  return &req;
}

Sct_CalibrationController_T_ScanRequest * ScanLibrary::defaultScan (Sct_CalibrationControllerStatus *_status) {
  ScanRequestImpl& req = defaultScan();
  req.incRef();
  return &req;
}

}
}
