#include "ScanLibraryImpl.h"
#include "CalibrationControllerImpl.h"
#include "scripts/ThresholdScan.h"
#include "scripts/StrobeDelayScan.h"
#include "scripts/NMaskScan.h"
#include "scripts/NoiseOccupancyScan.h"
#include "scripts/TokenScan.h"
#include "scripts/DefaultScan.h"
#include "scripts/RawScan.h"

namespace SctCalibrationController {
using namespace Scripts;    
    
ScanLibraryImpl::ScanLibraryImpl() {
    api = 0;
}
    
ScanLibraryImpl& ScanLibraryImpl::instance() {
    static ScanLibraryImpl* instance = new ScanLibraryImpl();
    return *instance;
}

ScanRequestImpl& ScanLibraryImpl::rawScan(unsigned long nTrigs) const {
    return RawScan::rawScan(nTrigs);
}

ScanRequestImpl& ScanLibraryImpl::thresholdScan(unsigned long nTrigs) const {
    return ThresholdScan::thresholdScan(nTrigs);
}

ScanRequestImpl& ScanLibraryImpl::thresholdScanfC(unsigned long nTrigs, double calCharge) const {
    return ThresholdScan::thresholdScan(nTrigs, calCharge);    
}

ScanRequestImpl& ScanLibraryImpl::thresholdScanfCOffset(unsigned long nTrigs, double calCharge, double offset) const {
    return ThresholdScan::thresholdScan(nTrigs, calCharge, offset);    
}

ScanRequestImpl& ScanLibraryImpl::noiseOccupancyScan() const {
    return NoiseOccupancyScan::noiseOccupancyScan();
}

ScanRequestImpl& ScanLibraryImpl::strobeDelayScan(unsigned long nTrigs) const {
    return StrobeDelayScan::strobeDelayScan(nTrigs);        
}

ScanRequestImpl& ScanLibraryImpl::nmaskScan(unsigned long nTrigs) const {
    return NMaskScan::nmaskScan(nTrigs);
}

ScanRequestImpl& ScanLibraryImpl::tokenScan() const {
    return TokenScan::tokenScan();
}

ScanRequestImpl& ScanLibraryImpl::defaultScan() const {
    return DefaultScan::defaultScan();
}

}
