#include "NPtGainConfigUpdater.h"
#include "ConfigUpdaterManager.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"

#include "Sct_SctApi/Sct_SctApi.hh"
#include "Sct/SctParameters.h"
#include "Sct/SctNames.h"
#include "SctData/NPtGainTestResult.h"
#include "SctData/ResponseCurve.h"
#include "SctData/DefectPrototype.h"

#include <TF1.h>

using namespace SctData;
using namespace Sct;

namespace SctCalibrationController {

bool NPtGainConfigUpdater::inMap = ConfigUpdaterManager::instance().setUpdater("SctData::NPtGainTestResult", shared_ptr<NPtGainConfigUpdater> (new NPtGainConfigUpdater() ) );

void NPtGainConfigUpdater::update(const TestResult& testresult, Sct_SctApi_T_SctApi& api) const {
    const NPtGainTestResult& t = dynamic_cast<const NPtGainTestResult&> (testresult) ;

    maskChannels(t, UNUSEABLE, api);
    if (t.getNScans() < 4) return;	//Don't update RC if it is a 3-pt gain, but do mask channels

    unsigned long mid = getMID(t, api);
    SctNames::Mrs() << "CC_UPDATE" << MRS_TEXT("CalibrationController updating response curve") << MRS_PARAM<const char*>("Module", t.getModuleName().c_str()) << MRS_INFORMATION << ENDM;
    for (unsigned ichip=0; ichip<Sct::nChipModule; ++ichip) {
	shared_ptr<const ResponseCurve> rc = t.getChipData(ichip).rc;
	shared_ptr<const TF1> func = rc->getFunction();
/*	SctNames::Mrs() << "CC_UPDATE_INFO" << MRS_TEXT("CalibrationController updating response curve") << MRS_PARAM<long>("ModuleID", mid) << MRS_PARAM<int>("Chip", ichip)
		        << MRS_PARAM<int>("Function", rc->getIndex()) << MRS_PARAM<double>("Param0", (double) func->GetParameter(0))
			<< MRS_PARAM<double>("Param1", (double) func->GetParameter(1)) << MRS_PARAM<double>("Param2", (double) func->GetParameter(2))
			<< MRS_DIAGNOSTIC << ENDM;*/
        APICALL(&api, modifyABCDRC(&st, mid, ichip, rc->getIndex(), func->GetParameter(0), func->GetParameter(1),
                                   func->GetParameter(2)), "NPtGainConfigUpdater failed to set rc params")
    }
}
}
