#ifndef SCT_CALIBRATIONCONTROL_CONFIGUPDATER
#define SCT_CALIBRATIONCONTROL_CONFIGUPDATER

#include <boost/noncopyable.hpp>
#include "SctData/DefectPrototype.h"

namespace SctData {
    class TestResult;
    class ModuleConfiguration;
    class ModuleElement;
}

class Sct_SctApi_T_SctApi;

namespace SctCalibrationController {

/**
   Algorithm interface for updating the module configuration after the 
   result of a test (TestResult) becomes available.
   Concrete sub-classes must impliment the update() method.
   Applies changes via the IPC interface of the SctApi.
*/
class ConfigUpdater : boost::noncopyable {
public:
    /**
      Sub-classes should override this to apply changes to a module configuration
      as a result of a Test.
      @throws SctApiAccessException if there is a problem with the api
      */
    virtual void update(const SctData::TestResult& t, Sct_SctApi_T_SctApi& api) const = 0;
    
protected:
    ConfigUpdater(){;}
    virtual ~ConfigUpdater(){;}
    
    /**
      Gets the module id for a TestResult
      @throws SctApiAccessException if there is a problem with the api
      */
    unsigned long getMID(const SctData::TestResult& t, Sct_SctApi_T_SctApi& api) const;
    
    /**
      Masks all channels with a severity >= s
      @throws SctApiAccessException if there is a problem with the api
      */
    void maskChannels(const SctData::TestResult& t, SctData::DefectSeverity s, Sct_SctApi_T_SctApi& api) const;    
    
private:
    /**
      Masks all the channels in element
      */
    void maskChannels(SctData::ModuleConfiguration& config, SctData::ModuleElement element) const;
};

} // end of namespace CallibrationController

#endif
