#ifndef SCTARCHIVING_ZLIBEXCEPTION_H
#define SCTARCHIVING_ZLIBEXCEPTION_H
#include "Sct/Exception.h"
using namespace std;

namespace SctArchiving{
/**
 * Thrown when an error occurs in <A HREF="http://www.gzip.org/zlib/">zlib</A>.
 * @ingroup Exceptions
 * @author Alan Barr
 */
  class ZlibException : public Sct::Exception{
 public:
    /**
      Creates an Exception with a cause.
    */
    ZlibException(const string& msg, const string& file, int line) throw() {
      initialize("ZLIB_ERROR", "SctArchiving::ZlibException", msg, 0, file, line);
    }
    /**
       Creates an Exception without a cause;
    */
    ZlibException(const string& msg, Throwable* cause, 
		  const string& file, int line) throw() {
      initialize("ZLIB_ERROR", "Sct::ZlibException", msg, cause, file, line);
    }
  protected:
    ZlibException() throw() {} 
};
}

#endif // SCTARCHIVING_ZLIBEXCEPTION_H
